/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.shaded.eyessdk.org.apache.http.impl.client;

import com.applitools.shaded.eyessdk.org.apache.commons.logging.Log;
import com.applitools.shaded.eyessdk.org.apache.commons.logging.LogFactory;
import com.applitools.shaded.eyessdk.org.apache.http.Header;
import com.applitools.shaded.eyessdk.org.apache.http.HttpHost;
import com.applitools.shaded.eyessdk.org.apache.http.HttpResponse;
import com.applitools.shaded.eyessdk.org.apache.http.annotation.Immutable;
import com.applitools.shaded.eyessdk.org.apache.http.auth.AuthOption;
import com.applitools.shaded.eyessdk.org.apache.http.auth.AuthScheme;
import com.applitools.shaded.eyessdk.org.apache.http.auth.AuthScope;
import com.applitools.shaded.eyessdk.org.apache.http.auth.AuthenticationException;
import com.applitools.shaded.eyessdk.org.apache.http.auth.Credentials;
import com.applitools.shaded.eyessdk.org.apache.http.auth.MalformedChallengeException;
import com.applitools.shaded.eyessdk.org.apache.http.client.AuthCache;
import com.applitools.shaded.eyessdk.org.apache.http.client.AuthenticationHandler;
import com.applitools.shaded.eyessdk.org.apache.http.client.AuthenticationStrategy;
import com.applitools.shaded.eyessdk.org.apache.http.client.CredentialsProvider;
import com.applitools.shaded.eyessdk.org.apache.http.impl.client.BasicAuthCache;
import com.applitools.shaded.eyessdk.org.apache.http.protocol.HttpContext;
import com.applitools.shaded.eyessdk.org.apache.http.util.Args;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Immutable
class AuthenticationStrategyAdaptor
implements AuthenticationStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthenticationHandler handler;

    public AuthenticationStrategyAdaptor(AuthenticationHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean isAuthenticationRequested(HttpHost authhost, HttpResponse response, HttpContext context) {
        return this.handler.isAuthenticationRequested(response, context);
    }

    @Override
    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        return this.handler.getChallenges(response, context);
    }

    @Override
    public Queue<AuthOption> select(Map<String, Header> challenges, HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        AuthScheme authScheme;
        Args.notNull(challenges, "Map of auth challenges");
        Args.notNull(authhost, "Host");
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        LinkedList<AuthOption> options = new LinkedList<AuthOption>();
        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        if (credsProvider == null) {
            this.log.debug("Credentials provider not set in the context");
            return options;
        }
        try {
            authScheme = this.handler.selectScheme(challenges, response, context);
        }
        catch (AuthenticationException ex) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(ex.getMessage(), ex);
            }
            return options;
        }
        String id = authScheme.getSchemeName();
        Header challenge = challenges.get(id.toLowerCase(Locale.US));
        authScheme.processChallenge(challenge);
        AuthScope authScope = new AuthScope(authhost.getHostName(), authhost.getPort(), authScheme.getRealm(), authScheme.getSchemeName());
        Credentials credentials = credsProvider.getCredentials(authScope);
        if (credentials != null) {
            options.add(new AuthOption(authScheme, credentials));
        }
        return options;
    }

    @Override
    public void authSucceeded(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        if (this.isCachable(authScheme)) {
            if (authCache == null) {
                authCache = new BasicAuthCache();
                context.setAttribute("http.auth.auth-cache", authCache);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caching '" + authScheme.getSchemeName() + "' auth scheme for " + authhost);
            }
            authCache.put(authhost, authScheme);
        }
    }

    @Override
    public void authFailed(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        if (authCache == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing from cache '" + authScheme.getSchemeName() + "' auth scheme for " + authhost);
        }
        authCache.remove(authhost);
    }

    private boolean isCachable(AuthScheme authScheme) {
        if (authScheme == null || !authScheme.isComplete()) {
            return false;
        }
        String schemeName = authScheme.getSchemeName();
        return schemeName.equalsIgnoreCase("Basic") || schemeName.equalsIgnoreCase("Digest");
    }

    public AuthenticationHandler getHandler() {
        return this.handler;
    }
}

