/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.shaded.eyessdk.org.apache.http.client.methods;

import com.applitools.shaded.eyessdk.org.apache.http.Header;
import com.applitools.shaded.eyessdk.org.apache.http.HttpEntity;
import com.applitools.shaded.eyessdk.org.apache.http.HttpEntityEnclosingRequest;
import com.applitools.shaded.eyessdk.org.apache.http.HttpRequest;
import com.applitools.shaded.eyessdk.org.apache.http.ProtocolVersion;
import com.applitools.shaded.eyessdk.org.apache.http.RequestLine;
import com.applitools.shaded.eyessdk.org.apache.http.annotation.NotThreadSafe;
import com.applitools.shaded.eyessdk.org.apache.http.client.methods.HttpUriRequest;
import com.applitools.shaded.eyessdk.org.apache.http.message.AbstractHttpMessage;
import com.applitools.shaded.eyessdk.org.apache.http.message.BasicRequestLine;
import com.applitools.shaded.eyessdk.org.apache.http.params.HttpParams;
import java.net.URI;

@NotThreadSafe
public class HttpRequestWrapper
extends AbstractHttpMessage
implements HttpUriRequest {
    private final HttpRequest original;
    private final String method;
    private ProtocolVersion version;
    private URI uri;

    private HttpRequestWrapper(HttpRequest request) {
        this.original = request;
        this.version = this.original.getRequestLine().getProtocolVersion();
        this.method = this.original.getRequestLine().getMethod();
        this.uri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : null;
        this.setHeaders(request.getAllHeaders());
    }

    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : this.original.getProtocolVersion();
    }

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public String getMethod() {
        return this.method;
    }

    public void abort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isAborted() {
        return false;
    }

    public RequestLine getRequestLine() {
        String requestUri = null;
        requestUri = this.uri != null ? this.uri.toASCIIString() : this.original.getRequestLine().getUri();
        if (requestUri == null || requestUri.length() == 0) {
            requestUri = "/";
        }
        return new BasicRequestLine(this.method, requestUri, this.getProtocolVersion());
    }

    public HttpRequest getOriginal() {
        return this.original;
    }

    public String toString() {
        return this.getRequestLine() + " " + this.headergroup;
    }

    public static HttpRequestWrapper wrap(HttpRequest request) {
        if (request == null) {
            return null;
        }
        if (request instanceof HttpEntityEnclosingRequest) {
            return new HttpEntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
        }
        return new HttpRequestWrapper(request);
    }

    @Deprecated
    public HttpParams getParams() {
        if (this.params == null) {
            this.params = this.original.getParams().copy();
        }
        return this.params;
    }

    static class HttpEntityEnclosingRequestWrapper
    extends HttpRequestWrapper
    implements HttpEntityEnclosingRequest {
        private HttpEntity entity;

        public HttpEntityEnclosingRequestWrapper(HttpEntityEnclosingRequest request) {
            super(request);
            this.entity = request.getEntity();
        }

        public HttpEntity getEntity() {
            return this.entity;
        }

        public void setEntity(HttpEntity entity) {
            this.entity = entity;
        }

        public boolean expectContinue() {
            Header expect = this.getFirstHeader("Expect");
            return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        }
    }
}

