/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.shaded.eyessdk.javassist.bytecode;

import com.applitools.shaded.eyessdk.javassist.Modifier;
import com.applitools.shaded.eyessdk.javassist.bytecode.AccessFlag;
import com.applitools.shaded.eyessdk.javassist.bytecode.AnnotationsAttribute;
import com.applitools.shaded.eyessdk.javassist.bytecode.AttributeInfo;
import com.applitools.shaded.eyessdk.javassist.bytecode.BadBytecode;
import com.applitools.shaded.eyessdk.javassist.bytecode.ClassFile;
import com.applitools.shaded.eyessdk.javassist.bytecode.CodeAttribute;
import com.applitools.shaded.eyessdk.javassist.bytecode.FieldInfo;
import com.applitools.shaded.eyessdk.javassist.bytecode.MethodInfo;
import com.applitools.shaded.eyessdk.javassist.bytecode.ParameterAnnotationsAttribute;
import com.applitools.shaded.eyessdk.javassist.bytecode.SignatureAttribute;
import com.applitools.shaded.eyessdk.javassist.bytecode.StackMap;
import com.applitools.shaded.eyessdk.javassist.bytecode.StackMapTable;
import java.io.PrintWriter;
import java.util.List;

public class ClassFilePrinter {
    public static void print(ClassFile cf) {
        ClassFilePrinter.print(cf, new PrintWriter(System.out, true));
    }

    public static void print(ClassFile cf, PrintWriter out) {
        int acc;
        int i;
        int mod = AccessFlag.toModifier(cf.getAccessFlags() & 0xFFFFFFDF);
        out.println("major: " + cf.major + ", minor: " + cf.minor + " modifiers: " + Integer.toHexString(cf.getAccessFlags()));
        out.println(Modifier.toString(mod) + " class " + cf.getName() + " extends " + cf.getSuperclass());
        String[] infs = cf.getInterfaces();
        if (infs != null && infs.length > 0) {
            out.print("    implements ");
            out.print(infs[0]);
            for (i = 1; i < infs.length; ++i) {
                out.print(", " + infs[i]);
            }
            out.println();
        }
        out.println();
        List list = cf.getFields();
        int n = list.size();
        for (i = 0; i < n; ++i) {
            FieldInfo finfo = (FieldInfo)list.get(i);
            acc = finfo.getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(acc)) + " " + finfo.getName() + "\t" + finfo.getDescriptor());
            ClassFilePrinter.printAttributes(finfo.getAttributes(), out, 'f');
        }
        out.println();
        list = cf.getMethods();
        n = list.size();
        for (i = 0; i < n; ++i) {
            MethodInfo minfo = (MethodInfo)list.get(i);
            acc = minfo.getAccessFlags();
            out.println(Modifier.toString(AccessFlag.toModifier(acc)) + " " + minfo.getName() + "\t" + minfo.getDescriptor());
            ClassFilePrinter.printAttributes(minfo.getAttributes(), out, 'm');
            out.println();
        }
        out.println();
        ClassFilePrinter.printAttributes(cf.getAttributes(), out, 'c');
    }

    static void printAttributes(List list, PrintWriter out, char kind) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo ai = (AttributeInfo)list.get(i);
            if (ai instanceof CodeAttribute) {
                CodeAttribute ca = (CodeAttribute)ai;
                out.println("attribute: " + ai.getName() + ": " + ai.getClass().getName());
                out.println("max stack " + ca.getMaxStack() + ", max locals " + ca.getMaxLocals() + ", " + ca.getExceptionTable().size() + " catch blocks");
                out.println("<code attribute begin>");
                ClassFilePrinter.printAttributes(ca.getAttributes(), out, kind);
                out.println("<code attribute end>");
                continue;
            }
            if (ai instanceof AnnotationsAttribute) {
                out.println("annnotation: " + ai.toString());
                continue;
            }
            if (ai instanceof ParameterAnnotationsAttribute) {
                out.println("parameter annnotations: " + ai.toString());
                continue;
            }
            if (ai instanceof StackMapTable) {
                out.println("<stack map table begin>");
                StackMapTable.Printer.print((StackMapTable)ai, out);
                out.println("<stack map table end>");
                continue;
            }
            if (ai instanceof StackMap) {
                out.println("<stack map begin>");
                ((StackMap)ai).print(out);
                out.println("<stack map end>");
                continue;
            }
            if (ai instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)ai;
                String sig = sa.getSignature();
                out.println("signature: " + sig);
                try {
                    String s = kind == 'c' ? SignatureAttribute.toClassSignature(sig).toString() : (kind == 'm' ? SignatureAttribute.toMethodSignature(sig).toString() : SignatureAttribute.toFieldSignature(sig).toString());
                    out.println("           " + s);
                }
                catch (BadBytecode e) {
                    out.println("           syntax error");
                }
                continue;
            }
            out.println("attribute: " + ai.getName() + " (" + ai.get().length + " byte): " + ai.getClass().getName());
        }
    }
}

