/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.shaded.eyessdk.glassfish.jersey.client;

import com.applitools.shaded.eyessdk.glassfish.jersey.client.internal.LocalizationMessages;
import com.applitools.shaded.eyessdk.glassfish.jersey.process.internal.RequestExecutorFactory;
import com.applitools.shaded.eyessdk.glassfish.jersey.spi.RequestExecutorProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import jersey.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glassfish.hk2.api.ServiceLocator;

class ClientAsyncExecutorFactory
extends RequestExecutorFactory {
    private static final Logger LOGGER = Logger.getLogger(ClientAsyncExecutorFactory.class.getName());

    public ClientAsyncExecutorFactory(ServiceLocator locator, int defaultThreadPoolSize) {
        super(locator, defaultThreadPoolSize);
    }

    @Override
    protected RequestExecutorProvider getDefaultProvider(final Object ... initArgs) {
        return new RequestExecutorProvider(){

            @Override
            public ExecutorService getRequestingExecutor() {
                int poolSize = 0;
                if (initArgs != null && initArgs.length > 0 && initArgs[0] instanceof Integer && (poolSize = ((Integer)initArgs[0]).intValue()) <= 0) {
                    LOGGER.config(LocalizationMessages.IGNORED_ASYNC_THREADPOOL_SIZE(poolSize));
                }
                ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("jersey-client-async-executor-%d").build();
                if (poolSize > 0) {
                    LOGGER.config(LocalizationMessages.USING_FIXED_ASYNC_THREADPOOL(poolSize));
                    return Executors.newFixedThreadPool(poolSize, threadFactory);
                }
                return Executors.newCachedThreadPool(threadFactory);
            }

            @Override
            public void releaseRequestingExecutor(ExecutorService executor) {
                executor.shutdownNow();
            }
        };
    }
}

