/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.shaded.eyessdk.glassfish.jersey.client;

import com.applitools.shaded.eyessdk.glassfish.jersey.client.ChunkParser;
import com.applitools.shaded.eyessdk.glassfish.jersey.client.internal.LocalizationMessages;
import com.applitools.shaded.eyessdk.glassfish.jersey.internal.PropertiesDelegate;
import com.applitools.shaded.eyessdk.glassfish.jersey.message.MessageBodyWorkers;
import com.applitools.shaded.eyessdk.javax.ws.rs.core.GenericType;
import com.applitools.shaded.eyessdk.javax.ws.rs.core.MediaType;
import com.applitools.shaded.eyessdk.javax.ws.rs.core.MultivaluedMap;
import com.applitools.shaded.eyessdk.javax.ws.rs.ext.ReaderInterceptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChunkedInput<T>
extends GenericType<T>
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(ChunkedInput.class.getName());
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private ChunkParser parser = ChunkedInput.createParser("\r\n");
    private MediaType mediaType;
    private final InputStream inputStream;
    private final Annotation[] annotations;
    private final MultivaluedMap<String, String> headers;
    private final MessageBodyWorkers messageBodyWorkers;
    private final PropertiesDelegate propertiesDelegate;

    public static ChunkParser createParser(String boundary) {
        return new FixedBoundaryParser(boundary.getBytes());
    }

    public static ChunkParser createParser(byte[] boundary) {
        return new FixedBoundaryParser(boundary);
    }

    protected ChunkedInput(Type chunkType, InputStream inputStream, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, MessageBodyWorkers messageBodyWorkers, PropertiesDelegate propertiesDelegate) {
        super(chunkType);
        this.inputStream = inputStream;
        this.annotations = annotations;
        this.mediaType = mediaType;
        this.headers = headers;
        this.messageBodyWorkers = messageBodyWorkers;
        this.propertiesDelegate = propertiesDelegate;
    }

    public ChunkParser getParser() {
        return this.parser;
    }

    public void setParser(ChunkParser parser) {
        this.parser = parser;
    }

    public MediaType getChunkType() {
        return this.mediaType;
    }

    public void setChunkType(MediaType mediaType) throws IllegalArgumentException {
        if (mediaType == null) {
            throw new IllegalArgumentException(LocalizationMessages.CHUNKED_INPUT_MEDIA_TYPE_NULL());
        }
        this.mediaType = mediaType;
    }

    public void setChunkType(String mediaType) throws IllegalArgumentException {
        this.mediaType = MediaType.valueOf(mediaType);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true) && this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, LocalizationMessages.CHUNKED_INPUT_STREAM_CLOSING_ERROR(), e);
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public T read() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException(LocalizationMessages.CHUNKED_INPUT_CLOSED());
        }
        try {
            byte[] chunk = this.parser.readChunk(this.inputStream);
            if (chunk != null) {
                ByteArrayInputStream chunkStream = new ByteArrayInputStream(chunk);
                return (T)this.messageBodyWorkers.readFrom(this.getRawType(), this.getType(), this.annotations, this.mediaType, this.headers, this.propertiesDelegate, chunkStream, Collections.<ReaderInterceptor>emptyList(), false);
            }
            this.close();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, e.getMessage(), e);
            this.close();
        }
        return null;
    }

    private static class FixedBoundaryParser
    implements ChunkParser {
        private final byte[] delimiter;

        public FixedBoundaryParser(byte[] boundary) {
            this.delimiter = Arrays.copyOf(boundary, boundary.length);
        }

        @Override
        public byte[] readChunk(InputStream in) throws IOException {
            int data;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] delimiterBuffer = new byte[this.delimiter.length];
            block0: do {
                int dPos = 0;
                while ((data = in.read()) != -1) {
                    byte b = (byte)data;
                    if (b == this.delimiter[dPos]) {
                        delimiterBuffer[dPos++] = b;
                        if (dPos != this.delimiter.length) continue;
                        continue block0;
                    }
                    if (dPos > 0) {
                        buffer.write(delimiterBuffer, 0, dPos);
                        dPos = 0;
                    }
                    buffer.write(b);
                }
            } while (data != -1 && buffer.size() == 0);
            if (buffer.size() > 0) {
                return buffer.toByteArray();
            }
            return null;
        }
    }
}

