/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.shaded.eyessdk.fasterxml.jackson.databind.ser.std;

import com.applitools.shaded.eyessdk.fasterxml.jackson.core.JsonGenerationException;
import com.applitools.shaded.eyessdk.fasterxml.jackson.core.JsonGenerator;
import com.applitools.shaded.eyessdk.fasterxml.jackson.databind.BeanProperty;
import com.applitools.shaded.eyessdk.fasterxml.jackson.databind.JavaType;
import com.applitools.shaded.eyessdk.fasterxml.jackson.databind.JsonSerializer;
import com.applitools.shaded.eyessdk.fasterxml.jackson.databind.SerializationFeature;
import com.applitools.shaded.eyessdk.fasterxml.jackson.databind.SerializerProvider;
import com.applitools.shaded.eyessdk.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.applitools.shaded.eyessdk.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.EnumSet;

public class EnumSetSerializer
extends AsArraySerializerBase<EnumSet<? extends Enum<?>>> {
    public EnumSetSerializer(JavaType elemType, BeanProperty property) {
        super(EnumSet.class, elemType, true, null, property, null);
    }

    public EnumSetSerializer(EnumSetSerializer src, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSerializer) {
        super(src, property, vts, valueSerializer);
    }

    public EnumSetSerializer _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    public EnumSetSerializer withResolved(BeanProperty property, TypeSerializer vts, JsonSerializer<?> elementSerializer) {
        return new EnumSetSerializer(this, property, vts, elementSerializer);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, EnumSet<? extends Enum<?>> value) {
        return value == null || value.isEmpty();
    }

    @Override
    public boolean hasSingleElement(EnumSet<? extends Enum<?>> value) {
        return value.size() == 1;
    }

    @Override
    public final void serialize(EnumSet<? extends Enum<?>> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        int len = value.size();
        if (len == 1 && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED)) {
            this.serializeContents(value, jgen, provider);
            return;
        }
        jgen.writeStartArray(len);
        this.serializeContents(value, jgen, provider);
        jgen.writeEndArray();
    }

    @Override
    public void serializeContents(EnumSet<? extends Enum<?>> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        JsonSerializer<Object> enumSer = this._elementSerializer;
        for (Enum enum_ : value) {
            if (enumSer == null) {
                enumSer = provider.findValueSerializer(enum_.getDeclaringClass(), this._property);
            }
            enumSer.serialize(enum_, jgen, provider);
        }
    }
}

