/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Location;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

class EyesScreenshot {
    protected BufferedImage image;
    protected Region bounds;

    public EyesScreenshot(BufferedImage image, Location location) {
        ArgumentGuard.notNull(image, "image");
        ArgumentGuard.notNull(location, "location");
        this.image = image;
        this.bounds = new Region(location, new RectangleSize(image.getWidth(), image.getHeight()));
    }

    public EyesScreenshot(BufferedImage image) {
        this(image, new Location(0, 0));
    }

    public BufferedImage getImage() {
        return this.image;
    }

    protected Region getIntersectedRegion(Region region) {
        ArgumentGuard.notNull(region, "region");
        Region intersectedRegion = new Region(region);
        intersectedRegion.intersect(this.bounds);
        return intersectedRegion;
    }

    protected BufferedImage getSubImage(Region region) {
        BufferedImage subScreenshotImage = this.image.getSubimage(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)subScreenshotImage, "png", temp);
            ByteArrayInputStream readTemp = new ByteArrayInputStream(temp.toByteArray());
            temp.close();
            subScreenshotImage = ImageIO.read(readTemp);
            readTemp.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed to copy region from screenshot", e);
        }
        return subScreenshotImage;
    }

    public EyesScreenshot getSubScreenshot(Region region) {
        ArgumentGuard.notNull(region, "region");
        Region subScreenshotRegion = this.getIntersectedRegion(region);
        if (subScreenshotRegion.isEmpty()) {
            throw new OutOfBoundsException(String.format("Region [%s] has no intersection with the screenshot [%s]", region, this.bounds));
        }
        Region relativeRegion = new Region(subScreenshotRegion);
        Location relativeLocation = relativeRegion.getLocation();
        relativeLocation.offset(-this.bounds.getLeft(), -this.bounds.getTop());
        relativeRegion.setLocation(relativeLocation);
        BufferedImage subScreenshotImage = this.getSubImage(relativeRegion);
        return new EyesScreenshot(subScreenshotImage, subScreenshotRegion.getLocation());
    }

    public Region getBounds() {
        return this.bounds;
    }
}

