/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.RestClient;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TestResults;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

class AgentConnector
extends RestClient {
    private static final int TIMEOUT = 300000;
    private static final String API_PATH = "/api/sessions/running";
    protected final HttpAuthenticationFeature authFeature;

    public AgentConnector(String agentId, URI agentUri, ProxySettings proxySettings) {
        super(agentUri, 300000, proxySettings);
        this.authFeature = HttpAuthenticationFeature.basic((String)agentId, (String)EyesBase.getApiKey());
        this.endPoint = (WebTarget)this.endPoint.path(API_PATH).register((Object)this.authFeature);
    }

    public AgentConnector(String agentId, URI agentUri) {
        this(agentId, agentUri, null);
    }

    public RunningSession startSession(SessionStartInfo sessionStartInfo) throws EyesException {
        Response response;
        String postData;
        ArgumentGuard.notNull(sessionStartInfo, "sessionStartInfo");
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", e);
        }
        try {
            response = this.endPoint.request(new String[]{"application/json"}).post(Entity.json((Object)postData));
        }
        catch (RuntimeException e) {
            Logger.log("startSession(): Server request failed: " + e.getMessage());
            throw e;
        }
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        validStatusCodes.add(Response.Status.CREATED.getStatusCode());
        RunningSession runningSession = this.parseResponseWithJsonData(response, validStatusCodes, RunningSession.class);
        int statusCode = response.getStatus();
        boolean isNewSession = statusCode == Response.Status.CREATED.getStatusCode();
        runningSession.setIsNewSession(isNewSession);
        return runningSession;
    }

    public TestResults stopSession(RunningSession runningSession, final boolean isAborted, final boolean save) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        final String sessionId = runningSession.getId();
        final String currentTime = GeneralUtils.toRfc1123(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        RestClient.HttpMethodCall delete = new RestClient.HttpMethodCall(){

            public Response call() {
                WebTarget request = (WebTarget)AgentConnector.this.restClient.target(AgentConnector.this.serverUri).path(AgentConnector.API_PATH).register((Object)AgentConnector.this.authFeature);
                Invocation.Builder invocationBuilder = request.path(sessionId).queryParam("aborted", new Object[]{String.valueOf(isAborted)}).queryParam("updateBaseline", new Object[]{String.valueOf(save)}).request(new String[]{"application/json"}).header("Expect", (Object)"202-accepted").header("Date", (Object)currentTime);
                return invocationBuilder.delete();
            }
        };
        Response response = this.sendLongRequest(delete, "delete");
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        TestResults result = this.parseResponseWithJsonData(response, validStatusCodes, TestResults.class);
        return result;
    }

    public MatchResult matchWindow(RunningSession runningSession, MatchWindowData matchData) throws EyesException {
        byte[] requestData;
        byte[] jsonBytes;
        String jsonData;
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(matchData, "data");
        WebTarget runningSessionsEndpoint = this.endPoint.path(runningSession.getId());
        try {
            jsonData = this.jsonMapper.writeValueAsString((Object)matchData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize data for matchWindow!", e);
        }
        ByteArrayOutputStream jsonToBytesConverter = new ByteArrayOutputStream();
        try {
            jsonToBytesConverter.write(jsonData.getBytes("UTF-8"));
            jsonToBytesConverter.flush();
            jsonBytes = jsonToBytesConverter.toByteArray();
        }
        catch (IOException e) {
            throw new EyesException("Failed create binary data from JSON!", e);
        }
        ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
        DataOutputStream requestDos = new DataOutputStream(requestOutputStream);
        try {
            requestDos.writeInt(jsonBytes.length);
            requestDos.flush();
            requestOutputStream.write(jsonBytes);
            requestOutputStream.write(matchData.getScreenshot());
            requestOutputStream.flush();
            requestData = requestOutputStream.toByteArray();
            requestDos.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed send check window request!", e);
        }
        Response response = runningSessionsEndpoint.request(new String[]{"application/json"}).post(Entity.entity((Object)requestData, (String)"application/octet-stream"));
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        MatchResult result = this.parseResponseWithJsonData(response, validStatusCodes, MatchResult.class);
        return result;
    }
}

