/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.applitools.utils.GeneralUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EyesRunner0 {
    protected ServerConnector serverConnector = new ServerConnector();
    private TestResultsSummary allTestResults = null;
    protected final String BASE_AGENT_ID = "eyes.sdk.java";
    protected final String VERSION = "1.0.0";
    private boolean dontCloseBatches = false;
    protected Logger logger = new Logger();
    private final Map<String, IBatchCloser> batchesServerConnectorsMap = new HashMap<String, IBatchCloser>();

    public abstract TestResultsSummary getAllTestResultsImpl(boolean var1);

    public TestResultsSummary getAllTestResults() {
        return this.getAllTestResults(true);
    }

    public TestResultsSummary getAllTestResults(boolean shouldThrowException) {
        this.logger.log(new HashSet(), Stage.CLOSE, Type.CALLED, new Pair[0]);
        if (this.allTestResults != null) {
            return this.allTestResults;
        }
        try {
            this.allTestResults = this.getAllTestResultsImpl(shouldThrowException);
        }
        finally {
            this.deleteAllBatches();
        }
        this.serverConnector.closeConnector();
        this.logger.getLogHandler().close();
        return this.allTestResults;
    }

    private void deleteAllBatches() {
        if (this.dontCloseBatches) {
            return;
        }
        boolean dontCloseBatchesStr = GeneralUtils.getDontCloseBatches();
        if (dontCloseBatchesStr) {
            return;
        }
        this.logger.log(new HashSet(), Stage.CLOSE, Type.CLOSE_BATCH, new Pair[]{Pair.of((Object)"batchSize", (Object)this.batchesServerConnectorsMap.size())});
        for (String batch : this.batchesServerConnectorsMap.keySet()) {
            IBatchCloser connector = this.batchesServerConnectorsMap.get(batch);
            connector.closeBatch(batch);
        }
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
        if (!logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public void setDontCloseBatches(boolean dontCloseBatches) {
        this.dontCloseBatches = dontCloseBatches;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addBatch(String batchId, IBatchCloser batchCloser) {
        if (!this.batchesServerConnectorsMap.containsKey(batchId)) {
            this.batchesServerConnectorsMap.put(batchId, batchCloser);
        }
    }

    public void setServerUrl(String serverUrl) {
        if (serverUrl != null) {
            URI defaultServerUrl = GeneralUtils.getServerUrl();
            if (this.serverConnector.getServerUrl().equals(defaultServerUrl) && !serverUrl.equals(defaultServerUrl.toString())) {
                try {
                    this.serverConnector.setServerUrl(new URI(serverUrl));
                }
                catch (URISyntaxException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
                }
            } else if (!this.serverConnector.getServerUrl().toString().equals(serverUrl)) {
                throw new EyesException(String.format("Server url was already set to %s", this.serverConnector.getServerUrl()));
            }
        }
    }

    public String getServerUrl() {
        return this.serverConnector.getServerUrl().toString();
    }

    public String getApiKey() {
        return this.serverConnector.getApiKey();
    }

    public void setApiKey(String apiKey) {
        if (apiKey != null) {
            if (!this.serverConnector.wasApiKeySet()) {
                this.serverConnector.setApiKey(apiKey);
            } else if (!this.serverConnector.getApiKey().equals(apiKey)) {
                throw new EyesException(String.format("Api key was already set to %s", this.serverConnector.getApiKey()));
            }
        }
    }

    public void setServerConnector(ServerConnector serverConnector) {
        this.serverConnector = serverConnector;
    }

    public ServerConnector getServerConnector() {
        return this.serverConnector;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        if (proxySettings != null) {
            if (this.serverConnector.getProxy() == null) {
                this.serverConnector.setProxy(proxySettings);
            } else if (!this.serverConnector.getProxy().equals((Object)proxySettings)) {
                throw new EyesException("Proxy was already set");
            }
        }
    }

    public AbstractProxySettings getProxy() {
        return this.serverConnector.getProxy();
    }

    public void setAgentId(String agentId) {
        if (agentId != null) {
            this.serverConnector.setAgentId(agentId);
        }
    }

    public String getAgentId() {
        return this.serverConnector.getAgentId();
    }
}

