/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.Logger;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.fluent.BatchClose;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.applitools.utils.ArgumentGuard;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class EnabledBatchClose
extends BatchClose {
    ServerConnector serverConnector;
    private List<String> batchIds;

    EnabledBatchClose(Logger logger, String serverUrl, List<String> batchIds) {
        super(logger);
        this.serverConnector = new ServerConnector(logger);
        this.serverUrl = serverUrl;
        this.batchIds = batchIds;
    }

    @Override
    public EnabledBatchClose setUrl(String url) {
        ArgumentGuard.notNull((Object)url, (String)"url");
        this.serverUrl = url;
        return this;
    }

    @Override
    public EnabledBatchClose setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
        this.serverConnector.setApiKey(apiKey);
        return this;
    }

    @Override
    public EnabledBatchClose setProxy(ProxySettings proxySettings) {
        ArgumentGuard.notNull((Object)proxySettings, (String)"proxySettings");
        this.proxySettings = proxySettings;
        this.serverConnector.setProxy((AbstractProxySettings)proxySettings);
        return this;
    }

    @Override
    public EnabledBatchClose setBatchId(List<String> batchIds) {
        ArgumentGuard.notNull(batchIds, (String)"batchIds");
        ArgumentGuard.notContainsNull(batchIds, (String)"batchIds");
        this.batchIds = batchIds;
        return this;
    }

    public void close() {
        this.logger.log(new HashSet(), Stage.CLOSE, Type.CLOSE_BATCH, new Pair[]{Pair.of((Object)"batchSize", (Object)this.batchIds.size())});
        for (String batchId : this.batchIds) {
            this.serverConnector.closeBatch(batchId, this.serverUrl);
        }
    }
}

