/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ImageUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;

public class AppOutput {
    private final String title;
    private final String domUrl;
    private String screenshotUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RectangleSize viewport;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Location location;
    @JsonIgnore
    private final EyesScreenshot screenshot;
    @JsonIgnore
    private final byte[] screenshotBytes;

    public AppOutput(String title, EyesScreenshot screenshot, String domUrl, String screenshotUrl, Location location) {
        this.title = title;
        this.domUrl = domUrl;
        this.screenshotUrl = screenshotUrl;
        this.location = location;
        this.screenshot = screenshot;
        this.screenshotBytes = screenshot == null ? null : ImageUtils.encodeAsPng(screenshot.getImage());
    }

    public AppOutput(String title, EyesScreenshot screenshot, String domUrl, String screenshotUrl, Location location, RectangleSize viewport) {
        this(title, screenshot, domUrl, screenshotUrl, location);
        this.viewport = viewport;
    }

    public String getTitle() {
        return this.title;
    }

    public byte[] getScreenshotBytes() {
        return this.screenshotBytes;
    }

    public String getDomUrl() {
        return this.domUrl;
    }

    public String getScreenshotUrl() {
        return this.screenshotUrl;
    }

    public void setScreenshotUrl(String screenshotUrl) {
        this.screenshotUrl = screenshotUrl;
    }

    public RectangleSize getViewport() {
        return this.viewport;
    }

    public Location getLocation() {
        return this.location;
    }

    public EyesScreenshot getScreenshot() {
        return this.screenshot;
    }
}

