/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ServerConnector;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private final Logger logger;
    private final ServerConnector serverConnector;
    private final RunningSession runningSession;
    private final int defaultRetryTimeout;
    private final AppOutputProvider appOutputProvider;
    private EyesScreenshot lastScreenshot = null;
    private MatchResult matchResult;
    private Region lastScreenshotBounds;

    public MatchWindowTask(Logger logger, ServerConnector serverConnector, RunningSession runningSession, int retryTimeout, AppOutputProvider appOutputProvider) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        ArgumentGuard.notNull((Object)appOutputProvider, (String)"appOutputProvider");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout;
        this.appOutputProvider = appOutputProvider;
    }

    public MatchWindowTask(Logger logger, ServerConnector serverConnector, RunningSession runningSession, int retryTimeout) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout;
        this.appOutputProvider = null;
    }

    public MatchResult performMatch(Trigger[] userInputs, AppOutputWithScreenshot appOutput, String tag, boolean ignoreMismatch, ImageMatchSettings imageMatchSettings) {
        MatchWindowData data = new MatchWindowData(userInputs, appOutput.getAppOutput(), tag, ignoreMismatch, new MatchWindowData.Options(tag, userInputs, ignoreMismatch, false, false, false, imageMatchSettings));
        return this.serverConnector.matchWindow(this.runningSession, data);
    }

    public MatchResult matchWindow(Trigger[] userInputs, Region region, String tag, boolean shouldRunOnceOnTimeout, boolean ignoreMismatch, ICheckSettingsInternal checkSettingsInternal, int retryTimeout, EyesBase eyes) {
        if (retryTimeout < 0) {
            retryTimeout = this.defaultRetryTimeout;
        }
        this.logger.verbose(String.format("retryTimeout = %d", retryTimeout));
        EyesScreenshot screenshot = this.takeScreenshot(userInputs, region, tag, shouldRunOnceOnTimeout, ignoreMismatch, checkSettingsInternal, retryTimeout, eyes);
        if (ignoreMismatch) {
            return this.matchResult;
        }
        this.updateLastScreenshot(screenshot);
        this.updateBounds(region);
        return this.matchResult;
    }

    private void collectSimpleRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesBase eyes, EyesScreenshot screenshot) {
        imageMatchSettings.setIgnoreRegions(this.collectRegions(checkSettingsInternal.getIgnoreRegions(), eyes, screenshot));
        imageMatchSettings.setLayoutRegions(this.collectRegions(checkSettingsInternal.getLayoutRegions(), eyes, screenshot));
        imageMatchSettings.setStrictRegions(this.collectRegions(checkSettingsInternal.getStrictRegions(), eyes, screenshot));
        imageMatchSettings.setContentRegions(this.collectRegions(checkSettingsInternal.getContentRegions(), eyes, screenshot));
    }

    private Region[] collectRegions(GetRegion[] regionProviders, EyesBase eyes, EyesScreenshot screenshot) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (GetRegion regionProvider : regionProviders) {
            try {
                regions.addAll(regionProvider.getRegions(eyes, screenshot));
            }
            catch (OutOfBoundsException ex) {
                this.logger.log("WARNING - ignore region was out of bounds.");
            }
        }
        return regions.toArray(new Region[0]);
    }

    private void collectFloatingRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesBase eyes, EyesScreenshot screenshot) {
        ArrayList<FloatingMatchSettings> floatingRegions = new ArrayList<FloatingMatchSettings>();
        for (GetFloatingRegion floatingRegionProvider : checkSettingsInternal.getFloatingRegions()) {
            floatingRegions.addAll(floatingRegionProvider.getRegions(eyes, screenshot));
        }
        imageMatchSettings.setFloatingRegions(floatingRegions.toArray(new FloatingMatchSettings[0]));
    }

    public ImageMatchSettings createImageMatchSettings(ICheckSettingsInternal checkSettingsInternal, EyesBase eyes, EyesScreenshot screenshot) {
        ImageMatchSettings imageMatchSettings = null;
        if (checkSettingsInternal != null) {
            MatchLevel matchLevel = checkSettingsInternal.getMatchLevel();
            if (matchLevel == null) {
                matchLevel = eyes.getDefaultMatchSettings().getMatchLevel();
            }
            imageMatchSettings = new ImageMatchSettings(matchLevel, null);
            Boolean ignoreCaret = checkSettingsInternal.getIgnoreCaret();
            if (ignoreCaret == null) {
                ignoreCaret = eyes.getDefaultMatchSettings().getIgnoreCaret();
            }
            imageMatchSettings.setIgnoreCaret(ignoreCaret);
            this.collectSimpleRegions(checkSettingsInternal, imageMatchSettings, eyes, screenshot);
            this.collectFloatingRegions(checkSettingsInternal, imageMatchSettings, eyes, screenshot);
        }
        return imageMatchSettings;
    }

    private EyesScreenshot takeScreenshot(Trigger[] userInputs, Region region, String tag, boolean shouldMatchWindowRunOnceOnTimeout, boolean ignoreMismatch, ICheckSettingsInternal checkSettingsInternal, int retryTimeout, EyesBase eyes) {
        EyesScreenshot screenshot;
        long elapsedTimeStart = System.currentTimeMillis();
        if (0 == retryTimeout || shouldMatchWindowRunOnceOnTimeout) {
            if (shouldMatchWindowRunOnceOnTimeout) {
                GeneralUtils.sleep((long)retryTimeout);
            }
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, ignoreMismatch, checkSettingsInternal, eyes);
        } else {
            screenshot = this.retryTakingScreenshot(userInputs, region, tag, ignoreMismatch, checkSettingsInternal, retryTimeout, eyes);
        }
        double elapsedTime = (System.currentTimeMillis() - elapsedTimeStart) / 1000L;
        this.logger.verbose(String.format("Completed in %.2f seconds", elapsedTime));
        return screenshot;
    }

    private EyesScreenshot retryTakingScreenshot(Trigger[] userInputs, Region region, String tag, boolean ignoreMismatch, ICheckSettingsInternal checkSettingsInternal, int retryTimeout, EyesBase eyes) {
        long start = System.currentTimeMillis();
        EyesScreenshot screenshot = null;
        long retry = System.currentTimeMillis() - start;
        while (retry < (long)retryTimeout) {
            GeneralUtils.sleep((long)500L);
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, true, checkSettingsInternal, eyes);
            if (this.matchResult.getAsExpected()) break;
            retry = System.currentTimeMillis() - start;
        }
        if (!this.matchResult.getAsExpected()) {
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, ignoreMismatch, checkSettingsInternal, eyes);
        }
        return screenshot;
    }

    private EyesScreenshot tryTakeScreenshot(Trigger[] userInputs, Region region, String tag, boolean ignoreMismatch, ICheckSettingsInternal checkSettingsInternal, EyesBase eyes) {
        AppOutputWithScreenshot appOutput = this.appOutputProvider.getAppOutput(region, this.lastScreenshot, checkSettingsInternal);
        EyesScreenshot screenshot = appOutput.getScreenshot();
        ImageMatchSettings matchSettings = this.createImageMatchSettings(checkSettingsInternal, eyes, screenshot);
        this.matchResult = this.performMatch(userInputs, appOutput, tag, ignoreMismatch, matchSettings);
        return screenshot;
    }

    private void updateLastScreenshot(EyesScreenshot screenshot) {
        if (screenshot != null) {
            this.lastScreenshot = screenshot;
        }
    }

    private void updateBounds(Region region) {
        if (region.isSizeEmpty()) {
            if (this.lastScreenshot == null) {
                this.lastScreenshotBounds = new Region(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else {
                BufferedImage image = this.lastScreenshot.getImage();
                this.lastScreenshotBounds = new Region(0, 0, image.getWidth(), image.getHeight());
            }
        } else {
            this.lastScreenshotBounds = region;
        }
    }

    public Region getLastScreenshotBounds() {
        return this.lastScreenshotBounds;
    }
}

