/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.IgnoreRegionByRectangle;
import java.util.ArrayList;
import java.util.List;

public class CheckSettings
implements ICheckSettings,
ICheckSettingsInternal {
    private Region targetRegion;
    private List<GetRegion> ignoreRegions = new ArrayList<GetRegion>();
    private MatchLevel matchLevel;
    private Boolean ignoreCaret;
    private boolean stitchContent = false;
    private List<GetFloatingRegion> floatingRegions = new ArrayList<GetFloatingRegion>();
    private int timeout = -1;

    protected CheckSettings() {
    }

    protected CheckSettings(Region region) {
        this.targetRegion = region;
    }

    public CheckSettings(int timeout) {
        this.timeout = timeout;
    }

    protected void ignore(Region region) {
        this.ignore(new IgnoreRegionByRectangle(region));
    }

    protected void ignore(GetRegion regionProvider) {
        this.ignoreRegions.add(regionProvider);
    }

    protected void floating_(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floatingRegions.add(new FloatingRegionByRectangle(new Region(region.getLeft(), region.getTop(), region.getLeft() + region.getWidth(), region.getTop() + region.getHeight()), maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
    }

    protected void floating(GetFloatingRegion regionProvider) {
        this.floatingRegions.add(regionProvider);
    }

    @Override
    public ICheckSettings ignore(Region ... regions) {
        for (Region r : regions) {
            this.ignore(r);
        }
        return this;
    }

    @Override
    public ICheckSettings fully() {
        this.stitchContent = true;
        return this;
    }

    @Override
    public ICheckSettings floating(int maxOffset, Region ... regions) {
        for (Region r : regions) {
            this.floating_(r, maxOffset, maxOffset, maxOffset, maxOffset);
        }
        return this;
    }

    @Override
    public ICheckSettings floating(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floating_(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset);
        return this;
    }

    @Override
    public ICheckSettings timeout(int timeoutMilliseconds) {
        this.timeout = timeoutMilliseconds;
        return this;
    }

    @Override
    public ICheckSettings layout() {
        this.matchLevel = MatchLevel.LAYOUT;
        return this;
    }

    @Override
    public ICheckSettings exact() {
        this.matchLevel = MatchLevel.EXACT;
        return this;
    }

    @Override
    public ICheckSettings strict() {
        this.matchLevel = MatchLevel.STRICT;
        return this;
    }

    @Override
    public ICheckSettings content() {
        this.matchLevel = MatchLevel.CONTENT;
        return this;
    }

    @Override
    public ICheckSettings matchLevel(MatchLevel matchLevel) {
        this.matchLevel = matchLevel;
        return this;
    }

    @Override
    public ICheckSettings ignoreCaret(boolean ignoreCaret) {
        this.ignoreCaret = ignoreCaret;
        return this;
    }

    @Override
    public ICheckSettings ignoreCaret() {
        this.ignoreCaret = true;
        return this;
    }

    @Override
    public Region getTargetRegion() {
        return this.targetRegion;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean getStitchContent() {
        return this.stitchContent;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    @Override
    public GetRegion[] getIgnoreRegions() {
        return this.ignoreRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetFloatingRegion[] getFloatingRegions() {
        return this.floatingRegions.toArray(new GetFloatingRegion[0]);
    }

    @Override
    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    protected void updateTargetRegion(Region region) {
        this.targetRegion = region;
    }
}

