/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowDataWithScreenshot;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ServerConnector;
import com.applitools.eyes.ServerConnectorFactory;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.debug.FileDebugScreenshotsProvider;
import com.applitools.eyes.debug.NullDebugScreenshotProvider;
import com.applitools.eyes.diagnostics.ResponseTimeAlgorithm;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.positioning.InvalidPositionProvider;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.scaling.FixedScaleProvider;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.triggers.MouseTrigger;
import com.applitools.eyes.triggers.TextTrigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageDeltaCompressor;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.codec.binary.Base64;

public abstract class EyesBase {
    private static final int DEFAULT_MATCH_TIMEOUT = 2000;
    protected static final int USE_DEFAULT_TIMEOUT = -1;
    private boolean shouldMatchWindowRunOnceOnTimeout;
    private MatchWindowTask matchWindowTask;
    protected ServerConnector serverConnector;
    protected RunningSession runningSession;
    protected SessionStartInfo sessionStartInfo;
    protected PropertyHandler<RectangleSize> viewportSizeHandler;
    protected EyesScreenshot lastScreenshot;
    protected PropertyHandler<ScaleProvider> scaleProviderHandler;
    protected PropertyHandler<CutProvider> cutProviderHandler;
    protected PositionProvider positionProvider;
    private boolean isDisabled;
    protected Logger logger;
    private boolean isOpen;
    private String agentId;
    private String currentAppName;
    private String appName;
    private SessionType sessionType;
    private String testName;
    private ImageMatchSettings defaultMatchSettings;
    private int matchTimeout;
    private BatchInfo batch;
    private String hostApp;
    private String hostOS;
    private String baselineEnvName;
    private String environmentName;
    private String branchName;
    private String parentBranchName;
    private FailureReports failureReports;
    private final Queue<Trigger> userInputs;
    private final List<PropertyData> properties = new ArrayList<PropertyData>();
    private boolean saveNewTests;
    private boolean saveFailedTests;
    protected DebugScreenshotsProvider debugScreenshotsProvider;
    private boolean isViewportSizeSet;
    protected int stitchingOverlap = 50;

    public EyesBase(URI serverUrl) {
        if (this.isDisabled) {
            this.userInputs = null;
            return;
        }
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        this.logger = new Logger();
        this.scaleProviderHandler = new SimplePropertyHandler();
        this.scaleProviderHandler.set((Object)new NullScaleProvider());
        this.cutProviderHandler = new SimplePropertyHandler();
        this.cutProviderHandler.set((Object)new NullCutProvider());
        this.positionProvider = new InvalidPositionProvider();
        this.viewportSizeHandler = new SimplePropertyHandler();
        this.viewportSizeHandler.set(null);
        this.serverConnector = ServerConnectorFactory.create((Logger)this.logger, (String)this.getBaseAgentId(), (URI)serverUrl);
        this.matchTimeout = 2000;
        this.runningSession = null;
        this.defaultMatchSettings = new ImageMatchSettings();
        this.failureReports = FailureReports.ON_CLOSE;
        this.userInputs = new ArrayDeque<Trigger>();
        this.saveNewTests = true;
        this.saveFailedTests = false;
        this.agentId = null;
        this.lastScreenshot = null;
        this.debugScreenshotsProvider = new NullDebugScreenshotProvider();
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.serverConnector.setApiKey(apiKey);
    }

    public String getApiKey() {
        return this.serverConnector.getApiKey();
    }

    public void setServerUrl(URI serverUrl) {
        if (serverUrl == null) {
            this.serverConnector.setServerUrl(EyesBase.getDefaultServerUrl());
        } else {
            this.serverConnector.setServerUrl(serverUrl);
        }
    }

    public URI getServerUrl() {
        return this.serverConnector.getServerUrl();
    }

    public void setProxy(ProxySettings proxySettings) {
        this.serverConnector.setProxy(proxySettings);
    }

    public ProxySettings getProxy() {
        return this.serverConnector.getProxy();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.currentAppName != null ? this.currentAppName : this.appName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setParentBranchName(String branchName) {
        this.parentBranchName = branchName;
    }

    public String getParentBranchName() {
        return this.parentBranchName;
    }

    protected void clearUserInputs() {
        if (this.isDisabled) {
            return;
        }
        this.userInputs.clear();
    }

    protected Trigger[] getUserInputs() {
        if (this.isDisabled) {
            return null;
        }
        Trigger[] result = new Trigger[this.userInputs.size()];
        return this.userInputs.toArray(result);
    }

    public void setMatchTimeout(int ms) {
        int MIN_MATCH_TIMEOUT = 500;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.verbose("Setting match timeout to: " + ms);
        if (ms != 0 && 500 > ms) {
            throw new IllegalArgumentException("Match timeout must be set in milliseconds, and must be > 500");
        }
        this.matchTimeout = ms;
    }

    public int getMatchTimeout() {
        return this.matchTimeout;
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.saveNewTests = saveNewTests;
    }

    public boolean getSaveNewTests() {
        return this.saveNewTests;
    }

    public void setSaveFailedTests(boolean saveFailedTests) {
        this.saveFailedTests = saveFailedTests;
    }

    public boolean getSaveFailedTests() {
        return this.saveFailedTests;
    }

    public void setBatch(BatchInfo batch) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.verbose("setBatch(" + batch + ")");
        this.batch = batch;
    }

    public BatchInfo getBatch() {
        return this.batch;
    }

    public void setFailureReports(FailureReports failureReports) {
        this.failureReports = failureReports;
    }

    public FailureReports getFailureReports() {
        return this.failureReports;
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        ArgumentGuard.notNull((Object)defaultMatchSettings, (String)"defaultMatchSettings");
        this.defaultMatchSettings = defaultMatchSettings;
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.defaultMatchSettings;
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.defaultMatchSettings.setMatchLevel(matchLevel);
    }

    public MatchLevel getMatchLevel() {
        return this.defaultMatchSettings.getMatchLevel();
    }

    protected abstract String getBaseAgentId();

    protected String getFullAgentId() {
        String agentId = this.getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    public boolean getIsOpen() {
        return this.isOpen;
    }

    public static URI getDefaultServerUrl() {
        try {
            return new URI("https://eyesapi.applitools.com");
        }
        catch (URISyntaxException ex) {
            throw new EyesException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
    }

    public LogHandler getLogHandler() {
        return this.logger.getLogHandler();
    }

    public void setImageCut(CutProvider cutProvider) {
        if (cutProvider != null) {
            this.cutProviderHandler = new ReadOnlyPropertyHandler(this.logger, (Object)cutProvider);
        } else {
            this.cutProviderHandler = new SimplePropertyHandler();
            this.cutProviderHandler.set((Object)new NullCutProvider());
        }
    }

    public void setScaleRatio(Double scaleRatio) {
        if (scaleRatio != null) {
            this.scaleProviderHandler = new ReadOnlyPropertyHandler(this.logger, (Object)new FixedScaleProvider(scaleRatio));
        } else {
            this.scaleProviderHandler = new SimplePropertyHandler();
            this.scaleProviderHandler.set((Object)new NullScaleProvider());
        }
    }

    public double getScaleRatio() {
        return ((ScaleProvider)this.scaleProviderHandler.get()).getScaleRatio();
    }

    public void addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        DebugScreenshotsProvider prev = this.debugScreenshotsProvider;
        this.debugScreenshotsProvider = saveDebugScreenshots ? new FileDebugScreenshotsProvider() : new NullDebugScreenshotProvider();
        this.debugScreenshotsProvider.setPrefix(prev.getPrefix());
        this.debugScreenshotsProvider.setPath(prev.getPath());
    }

    public boolean getSaveDebugScreenshots() {
        return !(this.debugScreenshotsProvider instanceof NullDebugScreenshotProvider);
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.debugScreenshotsProvider.setPath(pathToSave);
    }

    public String getDebugScreenshotsPath() {
        return this.debugScreenshotsProvider.getPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.debugScreenshotsProvider.setPrefix(prefix);
    }

    public String getDebugScreenshotsPrefix() {
        return this.debugScreenshotsProvider.getPrefix();
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        return this.debugScreenshotsProvider;
    }

    public boolean getIgnoreCaret() {
        Boolean ignoreCaret = this.defaultMatchSettings.getIgnoreCaret();
        return ignoreCaret == null ? true : ignoreCaret;
    }

    public void setIgnoreCaret(boolean value) {
        this.defaultMatchSettings.setIgnoreCaret(Boolean.valueOf(value));
    }

    public int getStitchOverlap() {
        return this.stitchingOverlap;
    }

    public void setStitchOverlap(int pixels) {
        this.stitchingOverlap = pixels;
    }

    public TestResults close() {
        return this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResults close(boolean throwEx) {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
                TestResults testResults = null;
                return testResults;
            }
            this.logger.verbose(String.format("close(%b)", throwEx));
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            this.isOpen = false;
            this.lastScreenshot = null;
            this.clearUserInputs();
            if (this.runningSession == null) {
                this.logger.verbose("Server session was not started");
                this.logger.log("--- Empty test ended.");
                TestResults testResults = new TestResults();
                return testResults;
            }
            boolean isNewSession = this.runningSession.getIsNewSession();
            String sessionResultsUrl = this.runningSession.getUrl();
            this.logger.verbose("Ending server session...");
            boolean save = isNewSession && this.saveNewTests || !isNewSession && this.saveFailedTests;
            this.logger.verbose("Automatically save test? " + String.valueOf(save));
            TestResults results = this.serverConnector.stopSession(this.runningSession, false, save);
            results.setNew(isNewSession);
            results.setUrl(sessionResultsUrl);
            this.logger.verbose(results.toString());
            if (!(isNewSession || 0 >= results.getMismatches() && 0 >= results.getMissing())) {
                this.logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                if (throwEx) {
                    String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. See details at " + sessionResultsUrl;
                    throw new TestFailedException(results, message);
                }
                TestResults message = results;
                return message;
            }
            if (isNewSession) {
                String instructions = "Please approve the new baseline at " + sessionResultsUrl;
                this.logger.log("--- New test ended. " + instructions);
                if (throwEx) {
                    String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. " + instructions;
                    throw new NewTestException(results, message);
                }
                TestResults testResults = results;
                return testResults;
            }
            this.logger.log("--- Test passed. See details at " + sessionResultsUrl);
            TestResults testResults = results;
            return testResults;
        }
        finally {
            this.runningSession = null;
            this.currentAppName = null;
            this.logger.getLogHandler().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResponseTime(boolean isDeadlineExceeded) {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
            }
            this.logger.verbose(String.format("closeResponseTime(%b)", isDeadlineExceeded));
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            this.isOpen = false;
            if (this.runningSession == null) {
                this.logger.verbose("Server session was not started");
                this.logger.log("--- Empty test ended.");
                return;
            }
            boolean isNewSession = this.runningSession.getIsNewSession();
            String sessionResultsUrl = this.runningSession.getUrl();
            this.logger.verbose("Ending server session...");
            boolean save = isNewSession && this.saveNewTests;
            this.logger.verbose("Automatically save test? " + String.valueOf(save));
            TestResults results = this.serverConnector.stopSession(this.runningSession, false, save);
            results.setNew(isNewSession);
            results.setUrl(sessionResultsUrl);
            this.logger.verbose(results.toString());
            if (isDeadlineExceeded && !isNewSession) {
                this.logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. See details at " + sessionResultsUrl;
                throw new TestFailedException(results, message);
            }
            if (isNewSession) {
                String instructions = "Please approve the new baseline at " + sessionResultsUrl;
                this.logger.log("--- New test ended. " + instructions);
                String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. " + instructions;
                throw new NewTestException(results, message);
            }
            this.logger.log("--- Test passed. See details at " + sessionResultsUrl);
        }
        finally {
            this.runningSession = null;
            this.currentAppName = null;
            this.logger.getLogHandler().close();
        }
    }

    public void abortIfNotClosed() {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
                return;
            }
            this.isOpen = false;
            this.lastScreenshot = null;
            this.clearUserInputs();
            if (null == this.runningSession) {
                this.logger.verbose("Closed");
                return;
            }
            this.logger.verbose("Aborting server session...");
            try {
                this.serverConnector.stopSession(this.runningSession, true, false);
                this.logger.log("--- Test aborted.");
            }
            catch (EyesException ex) {
                this.logger.log("Failed to abort server session: " + ex.getMessage());
            }
        }
        finally {
            this.runningSession = null;
            this.logger.getLogHandler().close();
        }
    }

    public void setHostOS(String hostOS) {
        this.logger.log("Host OS: " + hostOS);
        this.hostOS = hostOS == null || hostOS.isEmpty() ? null : hostOS.trim();
    }

    public String getHostOS() {
        return this.hostOS;
    }

    public void setHostApp(String hostApp) {
        this.logger.log("Host App: " + hostApp);
        this.hostApp = hostApp == null || hostApp.isEmpty() ? null : hostApp.trim();
    }

    public String getHostApp() {
        return this.hostApp;
    }

    public void setBaselineName(String baselineName) {
        this.logger.log("Baseline environment name: " + baselineName);
        this.baselineEnvName = baselineName == null || baselineName.isEmpty() ? null : baselineName.trim();
    }

    public String getBaselineName() {
        return this.baselineEnvName;
    }

    public void setBaselineEnvName(String baselineEnvName) {
        this.logger.log("Baseline environment name: " + baselineEnvName);
        this.baselineEnvName = baselineEnvName == null || baselineEnvName.isEmpty() ? null : baselineEnvName.trim();
    }

    public String getBaselineEnvName() {
        return this.baselineEnvName;
    }

    public void setEnvName(String envName) {
        this.logger.log("Environment name: " + envName);
        this.environmentName = envName == null || envName.isEmpty() ? null : envName.trim();
    }

    public String getEnvName() {
        return this.environmentName;
    }

    @Deprecated
    public void setAppEnvironment(String hostOS, String hostApp) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.log("Warning: SetAppEnvironment is deprecated! Please use 'setHostOS' and 'setHostApp'");
        this.logger.verbose("setAppEnvironment(" + hostOS + ", " + hostApp + ")");
        this.setHostOS(hostOS);
        this.setHostApp(hostApp);
    }

    protected PositionProvider getPositionProvider() {
        return this.positionProvider;
    }

    protected void setPositionProvider(PositionProvider positionProvider) {
        this.positionProvider = positionProvider;
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch) {
        return this.checkWindowBase(regionProvider, tag, ignoreMismatch, -1);
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch, int retryTimeout) {
        return this.checkWindowBase(regionProvider, tag, ignoreMismatch, new CheckSettings(retryTimeout));
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            MatchResult result = new MatchResult();
            result.setAsExpected(true);
            return result;
        }
        if (tag == null) {
            tag = "";
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        this.ensureRunningSession();
        MatchResult result = this.matchWindow(regionProvider, tag, ignoreMismatch, checkSettings);
        this.logger.verbose("MatchWindow Done!");
        if (!ignoreMismatch) {
            this.clearUserInputs();
            this.lastScreenshot = result.getScreenshot();
        }
        this.validateResult(tag, result);
        this.logger.verbose("Done!");
        return result;
    }

    private MatchResult matchWindow(RegionProvider regionProvider, String tag, boolean ignoreMismatch, ICheckSettings checkSettings) {
        ICheckSettingsInternal checkSettingsInternal = checkSettings instanceof ICheckSettingsInternal ? (ICheckSettingsInternal)((Object)checkSettings) : null;
        int retryTimeout = -1;
        ImageMatchSettings imageMatchSettings = null;
        if (checkSettingsInternal != null) {
            retryTimeout = checkSettingsInternal.getTimeout();
            MatchLevel matchLevel = checkSettingsInternal.getMatchLevel();
            matchLevel = matchLevel == null ? this.getDefaultMatchSettings().getMatchLevel() : matchLevel;
            imageMatchSettings = new ImageMatchSettings(matchLevel, null);
            this.collectIgnoreRegions(checkSettingsInternal, imageMatchSettings);
            this.collectFloatingRegions(checkSettingsInternal, imageMatchSettings);
            Boolean ignoreCaret = checkSettingsInternal.getIgnoreCaret();
            imageMatchSettings.setIgnoreCaret(ignoreCaret == null ? this.getDefaultMatchSettings().getIgnoreCaret() : ignoreCaret);
        }
        this.logger.verbose(String.format("CheckWindowBase(%s, '%s', %b, %d)", regionProvider.getClass(), tag, ignoreMismatch, retryTimeout));
        this.logger.verbose("Calling match window...");
        MatchResult result = this.matchWindowTask.matchWindow(this.getUserInputs(), regionProvider.getRegion(), tag, this.shouldMatchWindowRunOnceOnTimeout, ignoreMismatch, imageMatchSettings, retryTimeout);
        return result;
    }

    private void collectIgnoreRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings) {
        ArrayList<Region> ignoreRegions = new ArrayList<Region>();
        for (GetRegion ignoreRegionProvider : checkSettingsInternal.getIgnoreRegions()) {
            ignoreRegions.add(ignoreRegionProvider.getRegion(this));
        }
        imageMatchSettings.setIgnoreRegions(ignoreRegions.toArray(new Region[0]));
    }

    private void collectFloatingRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings) {
        ArrayList<FloatingMatchSettings> floatingRegions = new ArrayList<FloatingMatchSettings>();
        for (GetFloatingRegion floatingRegionProvider : checkSettingsInternal.getFloatingRegions()) {
            floatingRegions.add(floatingRegionProvider.getRegion(this));
        }
        imageMatchSettings.setFloatingRegions(floatingRegions.toArray(new FloatingMatchSettings[0]));
    }

    private void validateResult(String tag, MatchResult result) {
        if (result.getAsExpected()) {
            return;
        }
        this.shouldMatchWindowRunOnceOnTimeout = true;
        if (!this.runningSession.getIsNewSession()) {
            this.logger.log(String.format("Mismatch! (%s)", tag));
        }
        if (this.getFailureReports() == FailureReports.IMMEDIATE) {
            throw new TestFailedException(String.format("Mismatch found in '%s' of '%s'", this.sessionStartInfo.getScenarioIdOrName(), this.sessionStartInfo.getAppIdOrName()));
        }
    }

    protected MatchWindowDataWithScreenshot testResponseTimeBase(RegionProvider regionProvider, Runnable action, int deadline, int timeout, long matchInterval) {
        MatchWindowDataWithScreenshot result;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return null;
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        ArgumentGuard.greaterThanZero((long)deadline, (String)"deadline");
        ArgumentGuard.greaterThanZero((long)timeout, (String)"timeout");
        ArgumentGuard.greaterThanZero((long)matchInterval, (String)"matchInterval");
        this.logger.verbose(String.format("testResponseTimeBase(regionProvider, %d, %d, %d)", deadline, timeout, matchInterval));
        if (this.runningSession == null) {
            this.logger.verbose("No running session, calling start session..");
            this.startSession();
            this.logger.verbose("Done!");
        }
        Thread actionThread = null;
        if (action != null) {
            this.logger.verbose("Starting webdriver action.");
            actionThread = new Thread(action);
            actionThread.start();
        }
        long startTime = System.currentTimeMillis();
        AppOutputProvider appOutputProvider = new AppOutputProvider(){

            @Override
            public AppOutputWithScreenshot getAppOutput(Region region, EyesScreenshot lastScreenshot_) {
                return EyesBase.this.getAppOutputWithScreenshot(region, null);
            }
        };
        if (this.runningSession.getIsNewSession()) {
            ResponseTimeAlgorithm.runNewProgressionSession(this.logger, this.serverConnector, this.runningSession, appOutputProvider, regionProvider, startTime, deadline);
            result = null;
        } else {
            result = ResponseTimeAlgorithm.runProgressionSessionForExistingBaseline(this.logger, this.serverConnector, this.runningSession, appOutputProvider, regionProvider, startTime, deadline, timeout, matchInterval);
        }
        if (actionThread != null) {
            this.logger.verbose("Making sure 'action' thread had finished...");
            try {
                actionThread.join(30000L);
            }
            catch (InterruptedException e) {
                this.logger.verbose("Got interrupted while waiting for 'action' to finish!");
            }
        }
        this.logger.verbose("Done!");
        return result;
    }

    protected void openBase(String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        this.logger.getLogHandler().open();
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
                return;
            }
            if (this.appName == null) {
                ArgumentGuard.notNull((Object)appName, (String)"appName");
            }
            ArgumentGuard.notNull((Object)testName, (String)"testName");
            this.logger.log("Agent = " + this.getFullAgentId());
            this.logger.verbose(String.format("openBase('%s', '%s', '%s')", appName, testName, viewportSize));
            this.validateApiKey();
            this.logOpenBase();
            this.validateSessionOpen();
            this.isViewportSizeSet = false;
            this.currentAppName = appName != null ? appName : this.appName;
            this.testName = testName;
            this.viewportSizeHandler.set((Object)viewportSize);
            this.sessionType = sessionType != null ? sessionType : SessionType.SEQUENTIAL;
            this.scaleProviderHandler.set((Object)new NullScaleProvider());
            this.ensureRunningSession();
            this.isOpen = true;
        }
        catch (EyesException e) {
            this.logger.log(e.getMessage());
            this.logger.getLogHandler().close();
            throw e;
        }
    }

    private void ensureRunningSession() {
        if (this.runningSession != null) {
            return;
        }
        this.logger.log("No running session, calling start session...");
        this.startSession();
        this.logger.log("Done!");
        this.matchWindowTask = new MatchWindowTask(this.logger, this.serverConnector, this.runningSession, this.matchTimeout, new AppOutputProvider(){

            @Override
            public AppOutputWithScreenshot getAppOutput(Region region, EyesScreenshot lastScreenshot) {
                return EyesBase.this.getAppOutputWithScreenshot(region, lastScreenshot);
            }
        });
    }

    private void validateApiKey() {
        if (this.getApiKey() == null) {
            String errMsg = "API key is missing! Please set it using setApiKey()";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    private void logOpenBase() {
        this.logger.log(String.format("Eyes server URL is '%s'", this.serverConnector.getServerUrl()));
        this.logger.verbose(String.format("Timeout = '%d'", this.serverConnector.getTimeout()));
        this.logger.log(String.format("matchTimeout = '%d' ", this.matchTimeout));
        this.logger.log(String.format("Default match settings = '%s' ", this.defaultMatchSettings));
        this.logger.log(String.format("FailureReports = '%s' ", new Object[]{this.failureReports}));
    }

    private void validateSessionOpen() {
        if (this.isOpen) {
            this.abortIfNotClosed();
            String errMsg = "A test is already running";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    protected abstract RectangleSize getViewportSize();

    protected abstract void setViewportSize(RectangleSize var1);

    public void setExplicitViewportSize(RectangleSize explicitViewportSize) {
        if (explicitViewportSize == null) {
            this.viewportSizeHandler = new SimplePropertyHandler();
            this.viewportSizeHandler.set(null);
            this.isViewportSizeSet = false;
            return;
        }
        this.logger.verbose("Viewport size explicitly set to " + explicitViewportSize);
        this.viewportSizeHandler = new ReadOnlyPropertyHandler(this.logger, (Object)new RectangleSize(explicitViewportSize.getWidth(), explicitViewportSize.getHeight()));
        this.isViewportSizeSet = true;
    }

    protected abstract String getInferredEnvironment();

    protected abstract EyesScreenshot getScreenshot();

    protected abstract String getTitle();

    protected void addUserInput(Trigger trigger) {
        if (this.isDisabled) {
            return;
        }
        ArgumentGuard.notNull((Object)trigger, (String)"trigger");
        this.userInputs.add(trigger);
    }

    protected void addTextTriggerBase(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)text, (String)"text");
        control = new Region(control);
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if ((control = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS)).isEmpty()) {
            this.logger.verbose(String.format("Ignoring '%s' (out of bounds)", text));
            return;
        }
        TextTrigger trigger = new TextTrigger(control, text);
        this.addUserInput(trigger);
        this.logger.verbose(String.format("Added %s", new Object[]{trigger}));
    }

    protected void addMouseTriggerBase(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", new Object[]{action}));
            return;
        }
        ArgumentGuard.notNull((Object)((Object)action), (String)"action");
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)cursor, (String)"cursor");
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", new Object[]{action}));
            return;
        }
        Location cursorInScreenshot = new Location(cursor);
        cursorInScreenshot.offset(control.getLocation());
        try {
            cursorInScreenshot = this.lastScreenshot.getLocationInScreenshot(cursorInScreenshot, CoordinatesType.CONTEXT_RELATIVE);
        }
        catch (OutOfBoundsException e) {
            this.logger.verbose(String.format("Ignoring %s (out of bounds)", new Object[]{action}));
            return;
        }
        Region controlScreenshotIntersect = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        if (!controlScreenshotIntersect.isEmpty()) {
            Location l = controlScreenshotIntersect.getLocation();
            cursorInScreenshot.offset(-l.getX(), -l.getY());
        }
        MouseTrigger trigger = new MouseTrigger(action, controlScreenshotIntersect, cursorInScreenshot);
        this.addUserInput(trigger);
        this.logger.verbose(String.format("Added %s", new Object[]{trigger}));
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = new AppEnvironment();
        if (this.hostOS != null) {
            appEnv.setOs(this.hostOS);
        }
        if (this.hostApp != null) {
            appEnv.setHostingApp(this.hostApp);
        }
        appEnv.setInferred(this.getInferredEnvironment());
        appEnv.setDisplaySize((RectangleSize)this.viewportSizeHandler.get());
        return appEnv;
    }

    protected void startSession() {
        BatchInfo testBatch;
        this.logger.verbose("startSession()");
        this.ensureViewportSize();
        if (this.batch == null) {
            this.logger.verbose("No batch set");
            testBatch = new BatchInfo(null);
        } else {
            this.logger.verbose("Batch is " + this.batch);
            testBatch = this.batch;
        }
        AppEnvironment appEnv = this.getAppEnvironment();
        this.logger.verbose("Application environment is " + appEnv);
        this.sessionStartInfo = new SessionStartInfo(this.getBaseAgentId(), this.sessionType, this.getAppName(), null, this.testName, testBatch, this.baselineEnvName, this.environmentName, appEnv, this.defaultMatchSettings, this.branchName, this.parentBranchName, this.properties);
        this.logger.verbose("Starting server session...");
        this.runningSession = this.serverConnector.startSession(this.sessionStartInfo);
        this.logger.verbose("Server session ID is " + this.runningSession.getId());
        String testInfo = "'" + this.testName + "' of '" + this.getAppName() + "' " + appEnv;
        if (this.runningSession.getIsNewSession()) {
            this.logger.log("--- New test started - " + testInfo);
            this.shouldMatchWindowRunOnceOnTimeout = true;
        } else {
            this.logger.log("--- Test started - " + testInfo);
            this.shouldMatchWindowRunOnceOnTimeout = false;
        }
    }

    private void ensureViewportSize() {
        if (!this.isViewportSizeSet) {
            try {
                if (this.viewportSizeHandler.get() == null) {
                    if (!(this.viewportSizeHandler instanceof ReadOnlyPropertyHandler)) {
                        this.viewportSizeHandler.set((Object)this.getViewportSize());
                    }
                } else {
                    this.setViewportSize((RectangleSize)this.viewportSizeHandler.get());
                }
                this.isViewportSizeSet = true;
            }
            catch (NullPointerException e) {
                this.isViewportSizeSet = false;
            }
        }
    }

    private AppOutputWithScreenshot getAppOutputWithScreenshot(Region region, EyesScreenshot lastScreenshot) {
        this.logger.verbose("getting screenshot...");
        EyesScreenshot screenshot = this.getScreenshot();
        this.logger.verbose("Done getting screenshot!");
        if (!region.isEmpty()) {
            screenshot = screenshot.getSubScreenshot(region, false);
            this.debugScreenshotsProvider.save(screenshot.getImage(), "SUB_SCREENSHOT");
        }
        this.logger.verbose("Compressing screenshot...");
        String compressResult = this.compressScreenshot64(screenshot, lastScreenshot);
        this.logger.verbose("Done! Getting title...");
        String title = this.getTitle();
        this.logger.verbose("Done!");
        AppOutputWithScreenshot result = new AppOutputWithScreenshot(new AppOutput(title, compressResult), screenshot);
        this.logger.verbose("Done!");
        return result;
    }

    private String compressScreenshot64(EyesScreenshot screenshot, EyesScreenshot lastScreenshot) {
        byte[] compressedScreenshot;
        ArgumentGuard.notNull((Object)screenshot, (String)"screenshot");
        BufferedImage screenshotImage = screenshot.getImage();
        byte[] uncompressed = ImageUtils.encodeAsPng((BufferedImage)screenshotImage);
        BufferedImage source = lastScreenshot != null ? lastScreenshot.getImage() : null;
        try {
            compressedScreenshot = ImageDeltaCompressor.compressByRawBlocks((BufferedImage)screenshotImage, (byte[])uncompressed, (BufferedImage)source);
        }
        catch (IOException e) {
            throw new EyesException("Failed to compress screenshot!", (Throwable)e);
        }
        return Base64.encodeBase64String((byte[])compressedScreenshot);
    }
}

