/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.utils.ArgumentGuard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.NotSupportedException;

public class UserAgent {
    private static final String MAJOR_MINOR = "(?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+)";
    private static final String PRODUCT = "(?:(?<product>%s)/(?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+))";
    private static final String[] VALUES_FOR_BROWSER_REGEX_EXCEPT_IE = new String[]{"Opera", "Chrome", "Safari", "Firefox", "Edge"};
    private static final Pattern IE_BROWSER_REGEX = Pattern.compile("(?:MS(?<product>IE) (?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+))");
    private String OS;
    private String OSMajorVersion;
    private String OSMinorVersion;
    private String Browser;
    private String BrowserMajorVersion;
    private String BrowserMinorVersion;
    private static List<Map.Entry<String, String>> noHeaders = new LinkedList<Map.Entry<String, String>>();
    private static final Pattern VERSION_REGEX = Pattern.compile(String.format("(?:(?<product>%s)/(?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+))", "Version"));
    private static Pattern[] OS_REGEXES = new Pattern[]{Pattern.compile("(?:(?<os>Windows) NT (?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+))"), Pattern.compile("(?:(?<os>Windows XP))"), Pattern.compile("(?:(?<os>Windows 2000))"), Pattern.compile("(?:(?<os>Windows NT))"), Pattern.compile("(?:(?<os>Windows))"), Pattern.compile("(?:(?<os>Mac OS X) (?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+))"), Pattern.compile("(?:(?<os>Android) (?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+))"), Pattern.compile("(?:(?<os>CPU(?: i[a-zA-Z]+)? OS) (?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+))"), Pattern.compile("(?:(?<os>Mac OS X))"), Pattern.compile("(?:(?<os>Mac_PowerPC))"), Pattern.compile("(?:(?<os>Linux))"), Pattern.compile("(?:(?<os>CrOS))"), Pattern.compile("(?:(?<os>SymbOS))")};
    private static final Pattern HIDDEN_IE_REGEX = Pattern.compile("(?:(?:rv:(?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+)\\) like Gecko))");
    private static final Pattern EDGE_REGEX = Pattern.compile(String.format("(?:(?<product>%s)/(?<major>[^ .;_)]+)[_.](?<minor>[^ .;_)]+))", "Edge"));

    private static Pattern[] getBrowserRegexes() {
        Pattern[] browserRegexes = new Pattern[VALUES_FOR_BROWSER_REGEX_EXCEPT_IE.length + 1];
        for (int i = 0; i < VALUES_FOR_BROWSER_REGEX_EXCEPT_IE.length; ++i) {
            String browser = VALUES_FOR_BROWSER_REGEX_EXCEPT_IE[i];
            browserRegexes[i] = Pattern.compile(String.format(PRODUCT, browser));
        }
        browserRegexes[browserRegexes.length - 1] = IE_BROWSER_REGEX;
        return browserRegexes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserAgent ParseUserAgentString(String userAgent, boolean unknowns) {
        Matcher versionMatch;
        ArgumentGuard.notNull((Object)userAgent, (String)"userAgent");
        userAgent = userAgent.trim();
        UserAgent result = new UserAgent();
        HashMap<String, Matcher> oss = new HashMap<String, Matcher>();
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (Pattern osRegex : OS_REGEXES) {
            Matcher matcher = osRegex.matcher(userAgent);
            if (!matcher.find()) continue;
            matchers.add(matcher);
            break;
        }
        for (Matcher m : matchers) {
            String os = m.group("os");
            if (os == null) continue;
            oss.put(os.toLowerCase(), m);
        }
        Matcher osmatch = null;
        if (matchers.size() == 0) {
            if (!unknowns) throw new NotSupportedException("Unknown OS: " + userAgent);
            result.OS = "Unknown";
        } else {
            osmatch = oss.size() > 1 && oss.containsKey("android") ? (Matcher)oss.get("android") : oss.values().toArray(new Matcher[0])[0];
            result.OS = osmatch.group("os");
            if (osmatch.groupCount() > 1) {
                result.OSMajorVersion = osmatch.group("major");
                result.OSMinorVersion = osmatch.group("minor");
            }
        }
        if (result.OS.startsWith("CPU")) {
            result.OS = "IOS";
        } else if (result.OS.equals("Windows XP")) {
            result.OS = "Windows";
            result.OSMajorVersion = "5";
            result.OSMinorVersion = "1";
        } else if (result.OS.equals("Windows 2000")) {
            result.OS = "Windows";
            result.OSMajorVersion = "5";
            result.OSMinorVersion = "0";
        } else if (result.OS.equals("Windows NT")) {
            result.OS = "Windows";
            result.OSMajorVersion = "4";
            result.OSMinorVersion = "0";
        } else if (result.OS.equals("Mac_PowerPC")) {
            result.OS = "Macintosh";
        } else if (result.OS.equals("CrOS")) {
            result.OS = "ChromeOS";
        }
        boolean browserOK = false;
        for (Pattern browserRegex : UserAgent.getBrowserRegexes()) {
            Matcher matcher = browserRegex.matcher(userAgent);
            if (!matcher.find()) continue;
            result.Browser = matcher.group("product");
            result.BrowserMajorVersion = matcher.group("major");
            result.BrowserMinorVersion = matcher.group("minor");
            browserOK = true;
            break;
        }
        if (result.OS.equals("Windows")) {
            Matcher iematch;
            Matcher edgeMatch = EDGE_REGEX.matcher(userAgent);
            if (edgeMatch.find()) {
                result.Browser = "Edge";
                result.BrowserMajorVersion = edgeMatch.group("major");
                result.BrowserMinorVersion = edgeMatch.group("minor");
            }
            if ((iematch = HIDDEN_IE_REGEX.matcher(userAgent)).find()) {
                result.Browser = "IE";
                result.BrowserMajorVersion = iematch.group("major");
                result.BrowserMinorVersion = iematch.group("minor");
                browserOK = true;
            }
        }
        if (!browserOK) {
            if (!unknowns) throw new NotSupportedException("Unknown browser: " + userAgent);
            result.Browser = "Unknown";
        }
        if (!(versionMatch = VERSION_REGEX.matcher(userAgent)).find()) return result;
        result.BrowserMajorVersion = versionMatch.group("major");
        result.BrowserMinorVersion = versionMatch.group("minor");
        return result;
    }

    public String getBrowser() {
        return this.Browser;
    }

    public String getBrowserMajorVersion() {
        return this.BrowserMajorVersion;
    }

    public String getBrowserMinorVersion() {
        return this.BrowserMinorVersion;
    }

    public String getOS() {
        return this.OS;
    }

    public String getOSMajorVersion() {
        return this.OSMajorVersion;
    }

    public String getOSMinorVersion() {
        return this.OSMinorVersion;
    }
}

