/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.ICheckSettings;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.RunningTest;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.ScreenshotProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.visualgrid.model.JobInfo;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.VGRegion;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.CheckTask;
import com.applitools.utils.ClassVersionGetter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class VisualGridRunningTest
extends RunningTest {
    static final int PARALLEL_STEPS_LIMIT = 1;
    private final Configuration configuration;
    final List<CheckTask> checkTasks = new ArrayList<CheckTask>();
    private JobInfo jobInfo;

    public VisualGridRunningTest(Logger logger, String eyesId, RenderBrowserInfo browserInfo, Configuration configuration) {
        super(browserInfo, logger);
        this.setTestId(String.format("%s/%s", eyesId, this.getTestId()));
        logger.log(this.getTestId(), Stage.GENERAL, new Pair[]{Pair.of((Object)"browserInfo", (Object)browserInfo)});
        this.configuration = configuration;
    }

    public VisualGridRunningTest(Logger logger, String eyesId, Configuration configuration, RenderBrowserInfo browserInfo, List<PropertyData> properties, ServerConnector serverConnector) {
        this(logger, eyesId, browserInfo, configuration);
        this.setServerConnector(serverConnector);
        if (properties != null) {
            for (PropertyData property : properties) {
                this.addProperty(property);
            }
        }
    }

    private void removeAllCheckTasks() {
        this.checkTasks.clear();
    }

    boolean isCheckTaskReadyForRender(CheckTask checkTask) {
        if (!this.getIsOpen()) {
            return false;
        }
        if (!this.checkTasks.contains(checkTask)) {
            return false;
        }
        int notRenderedStepsCount = 0;
        for (CheckTask task : this.checkTasks) {
            if (task.equals(checkTask)) break;
            if (task.isRenderFinished()) continue;
            ++notRenderedStepsCount;
        }
        return notRenderedStepsCount < 1;
    }

    @Override
    public MatchWindowData prepareForMatch(CheckTask checkTask) {
        ICheckSettingsInternal checkSettingsInternal;
        RenderStatusResults renderResult = checkTask.getRenderStatusResults();
        String imageLocation = renderResult.getImageLocation();
        String domLocation = renderResult.getDomLocation();
        String renderId = renderResult.getRenderId();
        RectangleSize visualViewport = renderResult.getVisualViewport();
        List<VGRegion> vgRegions = renderResult.getSelectorRegions();
        ArrayList<VGRegion> regions = new ArrayList<VGRegion>();
        if (vgRegions != null) {
            for (VGRegion reg : vgRegions) {
                if (reg.getError() != null) {
                    this.logger.log(TraceLevel.Error, this.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"regionError", (Object)reg.getError())});
                    continue;
                }
                regions.add(reg);
            }
        }
        if ((checkSettingsInternal = (ICheckSettingsInternal)((Object)checkTask.getCheckSettings())).getStitchContent() == null) {
            checkTask.getCheckSettings().fully();
        }
        this.logger.log(TraceLevel.Info, this.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"configuration", (Object)this.getConfiguration()), Pair.of((Object)"checkSettings", (Object)checkSettingsInternal)});
        ImageMatchSettings imageMatchSettings = MatchWindowTask.createImageMatchSettings(checkSettingsInternal, this);
        String tag = checkSettingsInternal.getName();
        AppOutput appOutput = new AppOutput(tag, null, domLocation, imageLocation, renderResult.getImagePositionInActiveFrame(), visualViewport);
        MatchWindowTask.collectRegions(imageMatchSettings, renderResult.getImagePositionInActiveFrame(), regions, checkTask.getRegionSelectors());
        MatchWindowTask.collectRegions(imageMatchSettings, checkSettingsInternal);
        return this.prepareForMatch(checkSettingsInternal, new ArrayList<Trigger>(), appOutput, tag, false, imageMatchSettings, renderId, checkTask.getSource());
    }

    @Override
    public CheckTask issueCheck(ICheckSettings checkSettings, List<VisualGridSelector[]> regionSelectors, String source) {
        CheckTask checkTask = new CheckTask(this, checkSettings, regionSelectors, source);
        this.checkTasks.add(checkTask);
        return checkTask;
    }

    @Override
    public void checkCompleted(CheckTask checkTask, MatchResult matchResult) {
        this.validateResult(matchResult);
        this.checkTasks.remove(checkTask);
    }

    @Override
    public void issueAbort(Throwable error, boolean forceAbort) {
        super.issueAbort(error, forceAbort);
        if (this.isTestAborted()) {
            this.removeAllCheckTasks();
        }
    }

    @Override
    public boolean isTestReadyToClose() {
        return super.isTestReadyToClose() && this.checkTasks.isEmpty();
    }

    @Override
    protected String getBaseAgentId() {
        return "eyes.selenium.visualgrid.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    @Override
    protected void getAppOutputForOcr(BaseOcrRegion ocrRegion) {
    }

    @Override
    protected ScreenshotProvider getScreenshotProvider() {
        return null;
    }

    @Override
    public String tryCaptureDom() {
        return null;
    }

    @Override
    protected Object getAppEnvironment() {
        return this.getJobInfo().getEyesEnvironment();
    }

    public JobInfo getJobInfo() {
        if (this.jobInfo != null) {
            return this.jobInfo;
        }
        SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("getJobInfo %s", this.browserInfo));
        RenderInfo renderInfo = new RenderInfo(this.browserInfo.getWidth(), this.browserInfo.getHeight(), null, null, null, this.browserInfo.getEmulationInfo(), this.browserInfo.getIosDeviceInfo());
        RenderRequest renderRequest = new RenderRequest(renderInfo, this.browserInfo.getPlatform(), this.browserInfo.getBrowserType());
        renderRequest.setTestId(this.getTestId());
        this.getServerConnector().getJobInfo((TaskListener<JobInfo[]>)listener, new RenderRequest[]{renderRequest});
        JobInfo[] jobInfos = (JobInfo[])listener.get();
        if (jobInfos == null) {
            throw new EyesException("Failed getting job info");
        }
        this.jobInfo = jobInfos[0];
        return this.jobInfo;
    }

    public String getRenderer() {
        return this.getJobInfo().getRenderer();
    }

    @Override
    protected String getBaselineEnvName() {
        String baselineEnvName = this.browserInfo.getBaselineEnvName();
        if (baselineEnvName != null) {
            return baselineEnvName;
        }
        return this.getConfigurationInstance().getBaselineEnvName();
    }

    @Override
    protected Configuration getConfigurationInstance() {
        return this.configuration;
    }
}

