/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.Logger;
import com.applitools.eyes.NetworkLogHandler;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.services.EyesServiceRunner;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.services.CheckTask;
import com.applitools.eyes.visualgrid.services.IEyes;
import com.applitools.eyes.visualgrid.services.RunnerOptions;
import com.applitools.eyes.visualgrid.services.VisualGridRunningTest;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VisualGridRunner
extends EyesRunner {
    private static final int CONCURRENCY_FACTOR = 5;
    static final int DEFAULT_CONCURRENCY = 5;
    private EyesServiceRunner eyesServiceRunner;
    final TestConcurrency testConcurrency;
    private boolean wasConcurrencyLogSent = false;
    final Set<IEyes> allEyes = Collections.synchronizedSet(new HashSet());
    private final Map<String, RGridResource> resourcesCacheMap = Collections.synchronizedMap(new HashMap());
    private RenderingInfo renderingInfo;
    private IDebugResourceWriter debugResourceWriter;
    private boolean isDisabled;
    private String suiteName;

    public VisualGridRunner() {
        this(Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(String suiteName) {
        this.testConcurrency = new TestConcurrency();
        this.init(suiteName);
    }

    public VisualGridRunner(int testConcurrency) {
        this(testConcurrency, Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(int testConcurrency, String suiteName) {
        this.testConcurrency = new TestConcurrency(testConcurrency, true);
        this.init(suiteName);
    }

    public VisualGridRunner(RunnerOptions runnerOptions) {
        this(runnerOptions, Thread.currentThread().getStackTrace()[2].getClassName());
    }

    public VisualGridRunner(RunnerOptions runnerOptions, String suiteName) {
        int testConcurrency = runnerOptions.getTestConcurrency() == null ? 5 : runnerOptions.getTestConcurrency();
        this.testConcurrency = new TestConcurrency(testConcurrency, false);
        this.setApiKey(runnerOptions.getApiKey());
        this.setServerUrl(runnerOptions.getServerUrl());
        this.setProxy(runnerOptions.getProxy());
        this.init(suiteName);
    }

    private void init(String suiteName) {
        this.suiteName = suiteName;
        this.eyesServiceRunner = new EyesServiceRunner(this.logger, this.serverConnector, this.allEyes, this.testConcurrency.actualConcurrency, this.debugResourceWriter, this.resourcesCacheMap);
        this.eyesServiceRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IEyes eyes, List<VisualGridRunningTest> newTests) {
        if (this.renderingInfo == null) {
            this.renderingInfo = this.serverConnector.getRenderInfo();
        }
        this.eyesServiceRunner.setRenderingInfo(this.renderingInfo);
        if (this.allEyes.isEmpty()) {
            this.setLogger(eyes.getLogger());
        }
        Set<IEyes> set = this.allEyes;
        synchronized (set) {
            this.allEyes.add(eyes);
        }
        try {
            String logMessage = this.getConcurrencyLog();
            if (logMessage != null) {
                NetworkLogHandler.sendSingleLog(this.serverConnector, TraceLevel.Notice, logMessage);
            }
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.OPEN, (Throwable)e, (String[])new String[0]);
        }
        this.addBatch(eyes.getBatchId(), eyes.getBatchCloser());
        this.eyesServiceRunner.openTests(newTests);
    }

    public synchronized void check(FrameData domData, List<CheckTask> checkTasks) {
        this.eyesServiceRunner.addResourceCollectionTask(domData, checkTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestResultsSummary getAllTestResultsImpl(boolean throwException) {
        boolean isRunning = true;
        while (isRunning && this.getError() == null) {
            isRunning = false;
            Set<IEyes> set = this.allEyes;
            synchronized (set) {
                for (IEyes eyes : this.allEyes) {
                    isRunning = isRunning || !eyes.isCompleted();
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.getError() != null) {
            throw new EyesException("Execution crashed", this.getError());
        }
        this.eyesServiceRunner.stopServices();
        Throwable exception = null;
        ArrayList<TestResultContainer> allResults = new ArrayList<TestResultContainer>();
        Set<IEyes> set = this.allEyes;
        synchronized (set) {
            for (IEyes eyes : this.allEyes) {
                List<TestResultContainer> eyesResults = eyes.getAllTestResults();
                for (TestResultContainer result : eyesResults) {
                    if (exception != null || result.getException() == null) continue;
                    exception = result.getException();
                }
                allResults.addAll(eyesResults);
            }
        }
        if (throwException && exception != null) {
            throw new Error(exception);
        }
        return new TestResultsSummary(allResults);
    }

    public Throwable getError() {
        return this.eyesServiceRunner.getError();
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.debugResourceWriter = debugResourceWriter;
        this.eyesServiceRunner.setDebugResourceWriter(debugResourceWriter);
    }

    public IDebugResourceWriter getDebugResourceWriter() {
        return this.debugResourceWriter;
    }

    public void setLogger(Logger logger) {
        this.eyesServiceRunner.setLogger(logger);
        this.logger = logger;
    }

    @Override
    public void setServerConnector(ServerConnector serverConnector) {
        super.setServerConnector(serverConnector);
        this.eyesServiceRunner.setServerConnector(serverConnector);
    }

    public String getConcurrencyLog() throws JsonProcessingException {
        if (this.wasConcurrencyLogSent) {
            return null;
        }
        this.wasConcurrencyLogSent = true;
        String key = this.testConcurrency.isDefault ? "defaultConcurrency" : (this.testConcurrency.isLegacy ? "concurrency" : "testConcurrency");
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("type", "runnerStarted");
        objectNode.put(key, this.testConcurrency.userConcurrency);
        return objectMapper.writeValueAsString((Object)objectNode);
    }

    public Map<String, RGridResource> getResourcesCacheMap() {
        return this.resourcesCacheMap;
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    static class TestConcurrency {
        final int userConcurrency;
        final int actualConcurrency;
        final boolean isLegacy;
        boolean isDefault = false;

        TestConcurrency() {
            this.isDefault = true;
            this.isLegacy = false;
            this.userConcurrency = 5;
            this.actualConcurrency = 5;
        }

        TestConcurrency(int userConcurrency, boolean isLegacy) {
            this.userConcurrency = userConcurrency;
            this.actualConcurrency = isLegacy ? userConcurrency * 5 : userConcurrency;
            this.isLegacy = isLegacy;
        }
    }
}

