/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.services.EyesService;
import com.applitools.eyes.visualgrid.services.ServiceTaskListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Pair;

public class OpenService
extends EyesService<SessionStartInfo, RunningSession> {
    int TIME_TO_WAIT_FOR_OPEN = 3600000;
    private final int eyesConcurrency;
    private final AtomicInteger currentTestAmount = new AtomicInteger();
    private boolean isServerConcurrencyLimitReached = false;
    private final Set<String> inProgressTests = Collections.synchronizedSet(new HashSet());

    public OpenService(Logger logger, ServerConnector serverConnector, int eyesConcurrency) {
        super(logger, serverConnector);
        this.eyesConcurrency = eyesConcurrency;
    }

    @Override
    public void run() {
        while (!this.inputQueue.isEmpty() && !this.isServerConcurrencyLimitReached && this.eyesConcurrency > this.currentTestAmount.get()) {
            this.currentTestAmount.incrementAndGet();
            this.logger.log(TraceLevel.Info, new HashSet(), Stage.OPEN, null, new Pair[]{Pair.of((Object)"testAmount", (Object)this.currentTestAmount.get())});
            final Pair nextInput = (Pair)this.inputQueue.remove(0);
            this.inProgressTests.add((String)nextInput.getLeft());
            this.operate((String)nextInput.getLeft(), (SessionStartInfo)nextInput.getRight(), new ServiceTaskListener<RunningSession>(){

                @Override
                public void onComplete(RunningSession output) {
                    OpenService.this.inProgressTests.remove(nextInput.getLeft());
                    OpenService.this.outputQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)output));
                }

                @Override
                public void onFail(Throwable t) {
                    OpenService.this.inProgressTests.remove(nextInput.getLeft());
                    OpenService.this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)t));
                }
            });
        }
    }

    public void operate(final String testId, final SessionStartInfo sessionStartInfo, final ServiceTaskListener<RunningSession> listener) {
        final AtomicInteger timePassed = new AtomicInteger(0);
        final AtomicInteger sleepDuration = new AtomicInteger(2000);
        TaskListener<RunningSession> taskListener = new TaskListener<RunningSession>(){

            public void onComplete(RunningSession runningSession) {
                OpenService.this.logger.log(testId, Stage.OPEN, new Pair[]{Pair.of((Object)"runningSession", (Object)runningSession)});
                if (runningSession.isConcurrencyFull()) {
                    OpenService.this.isServerConcurrencyLimitReached = true;
                    this.onFail();
                    return;
                }
                OpenService.this.isServerConcurrencyLimitReached = false;
                listener.onComplete(runningSession);
            }

            public void onFail() {
                if (timePassed.get() > OpenService.this.TIME_TO_WAIT_FOR_OPEN) {
                    OpenService.this.isServerConcurrencyLimitReached = false;
                    listener.onFail((Throwable)new EyesException("Timeout in start session"));
                    return;
                }
                try {
                    Thread.sleep(sleepDuration.get());
                    timePassed.set(timePassed.get() + sleepDuration.get());
                    if (timePassed.get() >= 30000) {
                        sleepDuration.set(10000);
                    } else if (timePassed.get() >= 10000) {
                        sleepDuration.set(5000);
                    }
                    OpenService.this.logger.log(testId, Stage.OPEN, Type.RETRY, new Pair[0]);
                    OpenService.this.serverConnector.startSession(this, sessionStartInfo);
                }
                catch (Throwable e) {
                    listener.onFail(e);
                }
            }
        };
        try {
            this.logger.log(testId, Stage.OPEN, new Pair[]{Pair.of((Object)"sessionStartInfo", (Object)sessionStartInfo)});
            this.serverConnector.startSession(taskListener, sessionStartInfo);
        }
        catch (Throwable t) {
            listener.onFail(t);
        }
    }

    public void decrementConcurrency() {
        int currentAmount = this.currentTestAmount.decrementAndGet();
        this.logger.log(TraceLevel.Info, new HashSet(), Stage.CLOSE, null, new Pair[]{Pair.of((Object)"testAmount", (Object)currentAmount)});
    }
}

