/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.SessionStopInfo;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.services.EyesService;
import com.applitools.eyes.visualgrid.services.ServiceTaskListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class CloseService
extends EyesService<SessionStopInfo, TestResults> {
    private final Set<String> inProgressTests = Collections.synchronizedSet(new HashSet());

    public CloseService(Logger logger, ServerConnector serverConnector) {
        super(logger, serverConnector);
    }

    @Override
    public void run() {
        while (!this.inputQueue.isEmpty()) {
            final Pair nextInput = (Pair)this.inputQueue.remove(0);
            this.inProgressTests.add((String)nextInput.getLeft());
            this.operate((String)nextInput.getLeft(), (SessionStopInfo)nextInput.getRight(), new ServiceTaskListener<TestResults>(){

                @Override
                public void onComplete(TestResults output) {
                    CloseService.this.inProgressTests.remove(nextInput.getLeft());
                    CloseService.this.outputQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)output));
                }

                @Override
                public void onFail(Throwable t) {
                    CloseService.this.inProgressTests.remove(nextInput.getLeft());
                    CloseService.this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)t));
                }
            });
        }
    }

    public void operate(final String testId, final SessionStopInfo sessionStopInfo, final ServiceTaskListener<TestResults> listener) {
        if (sessionStopInfo == null) {
            TestResults testResults = new TestResults();
            testResults.setStatus(TestResultsStatus.NotOpened);
            listener.onComplete(testResults);
            return;
        }
        TaskListener<TestResults> taskListener = new TaskListener<TestResults>(){

            public void onComplete(TestResults testResults) {
                CloseService.this.logger.log(testId, Stage.CLOSE, new Pair[]{Pair.of((Object)"testResults", (Object)testResults)});
                testResults.setNew(sessionStopInfo.getRunningSession().getIsNew());
                testResults.setUrl(sessionStopInfo.getRunningSession().getUrl());
                testResults.setServerConnector(CloseService.this.serverConnector);
                listener.onComplete(testResults);
            }

            public void onFail() {
                listener.onFail((Throwable)new EyesException("Failed closing test"));
            }
        };
        try {
            this.logger.log(testId, Stage.CLOSE, new Pair[]{Pair.of((Object)"sessionStopInfo", (Object)sessionStopInfo)});
            this.serverConnector.stopSession(taskListener, sessionStopInfo);
        }
        catch (Throwable t) {
            listener.onFail(t);
        }
    }
}

