/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.events;

import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.events.ISessionEventHandler;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.events.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public class SessionEventHandlers
implements ISessionEventHandler {
    private List<ISessionEventHandler> eventHandlers = new ArrayList<ISessionEventHandler>();

    public void addEventHandler(ISessionEventHandler handler) {
        if (handler == this) {
            return;
        }
        this.eventHandlers.add(handler);
    }

    public void removeEventHandler(ISessionEventHandler handler) {
        if (handler == this) {
            return;
        }
        this.eventHandlers.remove(handler);
    }

    public void clearEventHandlers() {
        this.eventHandlers.clear();
    }

    @Override
    public void initStarted() {
        for (ISessionEventHandler currentHandler : this.eventHandlers) {
            currentHandler.initStarted();
        }
    }

    @Override
    public void initEnded() {
        for (ISessionEventHandler currentHandler : this.eventHandlers) {
            currentHandler.initEnded();
        }
    }

    @Override
    public void setSizeWillStart(RectangleSize sizeToSet) {
        for (ISessionEventHandler currentHandler : this.eventHandlers) {
            currentHandler.setSizeWillStart(sizeToSet);
        }
    }

    @Override
    public void setSizeEnded() {
        for (ISessionEventHandler currentHandler : this.eventHandlers) {
            currentHandler.setSizeEnded();
        }
    }

    @Override
    public void testStarted(String autSessionId) {
        for (ISessionEventHandler currentHandler : this.eventHandlers) {
            currentHandler.testStarted(autSessionId);
        }
    }

    @Override
    public void testEnded(String autSessionId, TestResults testResults) {
        for (ISessionEventHandler currentHandler : this.eventHandlers) {
            currentHandler.testEnded(autSessionId, testResults);
        }
    }

    @Override
    public void validationWillStart(String autSessionId, ValidationInfo validationInfo) {
        for (ISessionEventHandler currentHandler : this.eventHandlers) {
            currentHandler.validationWillStart(autSessionId, validationInfo);
        }
    }

    @Override
    public void validationEnded(String autSessionId, String validationId, ValidationResult validationResult) {
        for (ISessionEventHandler currentHandler : this.eventHandlers) {
            currentHandler.validationEnded(autSessionId, validationId, validationResult);
        }
    }
}

