/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import java.awt.Point;

public final class Location
implements Cloneable {
    private final int x;
    private final int y;
    public static final Location ZERO = new Location(0, 0);

    public Location() {
        this.x = Location.ZERO.x;
        this.y = Location.ZERO.y;
    }

    public Location(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Location(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return this.getX() == other.getX() && this.getY() == other.getY();
    }

    public int hashCode() {
        return this.getX() + this.getY();
    }

    public Location(Location other) {
        if (other != null) {
            this.x = other.getX();
            this.y = other.getY();
        } else {
            this.x = 0;
            this.y = 0;
        }
    }

    public Location offset(int dx, int dy) {
        return new Location(this.x + dx, this.y + dy);
    }

    public Location offset(Location amount) {
        return this.offset(amount.getX(), amount.getY());
    }

    public Location scale(double scaleRatio) {
        return new Location((int)Math.ceil((double)this.x * scaleRatio), (int)Math.ceil((double)this.y * scaleRatio));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public String toStringForFilename() {
        return this.x + "_" + this.y;
    }
}

