/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultContainer;
import com.applitools.utils.GeneralUtils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EyesService
extends Thread {
    protected final int eyesConcurrency;
    protected ExecutorService executor;
    protected final EyesServiceListener listener;
    protected final Tasker tasker;
    protected boolean isServiceOn = true;
    protected Logger logger;

    public void setLogger(Logger logger) {
        if (this.logger == null) {
            this.logger = logger;
        } else {
            this.logger.setLogHandler(logger.getLogHandler());
        }
    }

    public EyesService(String serviceName, ThreadGroup servicesGroup, Logger logger, int eyesConcurrency, EyesServiceListener listener, Tasker tasker) {
        super(servicesGroup, serviceName);
        this.eyesConcurrency = eyesConcurrency;
        this.executor = new ThreadPoolExecutor(this.eyesConcurrency, this.eyesConcurrency, 1L, TimeUnit.DAYS, new ArrayBlockingQueue<Runnable>(50));
        this.listener = listener;
        this.logger = logger;
        this.tasker = tasker;
    }

    @Override
    public void run() {
        try {
            this.logger.log("Service '" + this.getName() + "' had started");
            while (this.isServiceOn) {
                this.runNextTask();
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
            this.logger.log("Service '" + this.getName() + "' is finished");
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
    }

    void runNextTask() {
        if (!this.isServiceOn) {
            return;
        }
        FutureTask<TestResultContainer> task = this.listener.getNextTask(this.tasker);
        if (task != null) {
            this.executor.submit(task);
        }
    }

    void stopService() {
        this.logger.verbose(this.getName() + " service is Stopped");
        this.isServiceOn = false;
    }

    public static interface EyesServiceListener {
        public FutureTask<TestResultContainer> getNextTask(Tasker var1);
    }

    static interface Tasker {
        public FutureTask<TestResultContainer> getNextTask();
    }
}

