/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.ICheckSettings;
import com.applitools.ICheckSettingsInternal;
import com.applitools.connectivity.UfgConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.visualgrid.model.DomAnalyzer;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.HashObject;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RenderingTask;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.VisualGridRunner;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ResourceCollectionTask
implements Callable<TestResultContainer> {
    public static final String FULLPAGE = "full-page";
    public static final String VIEWPORT = "viewport";
    private final Logger logger;
    private final IEyesConnector eyesConnector;
    private final FrameData domData;
    private final UserAgent userAgent;
    private final RenderingInfo renderingInfo;
    private final List<VisualGridSelector[]> regionSelectors;
    private final ICheckSettings checkSettings;
    private final List<VisualGridTask> checkTasks;
    final Map<String, RGridResource> resourcesCacheMap;
    final Map<String, SyncTaskListener<Void>> uploadedResourcesCache;
    private IDebugResourceWriter debugResourceWriter;
    private final TaskListener<List<RenderingTask>> listener;
    private RenderingTask.RenderTaskListener renderTaskListener;

    public ResourceCollectionTask(IEyesConnector eyesConnector, List<VisualGridTask> checkTasks, FrameData domData, UserAgent userAgent, ICheckSettings checkSettings, TaskListener<List<RenderingTask>> listTaskListener) {
        this.eyesConnector = eyesConnector;
        this.checkTasks = checkTasks;
        this.domData = domData;
        this.userAgent = userAgent;
        this.checkSettings = checkSettings;
        this.listener = listTaskListener;
        this.resourcesCacheMap = new HashMap<String, RGridResource>();
        this.uploadedResourcesCache = new HashMap<String, SyncTaskListener<Void>>();
        this.logger = new Logger();
        this.regionSelectors = new ArrayList<VisualGridSelector[]>();
        this.renderingInfo = new RenderingInfo();
    }

    public ResourceCollectionTask(VisualGridRunner runner, IEyesConnector eyesConnector, FrameData domData, UserAgent userAgent, List<VisualGridSelector[]> regionSelectors, ICheckSettings checkSettings, List<VisualGridTask> checkTasks, IDebugResourceWriter debugResourceWriter, TaskListener<List<RenderingTask>> listener, RenderingTask.RenderTaskListener renderTaskListener) {
        ArgumentGuard.notNull(checkTasks, (String)"checkTasks");
        ArgumentGuard.notEqual((Object)checkTasks.size(), (Object)0, (String)"checkTasks");
        this.logger = runner.getLogger();
        this.eyesConnector = eyesConnector;
        this.resourcesCacheMap = runner.getResourcesCacheMap();
        this.uploadedResourcesCache = runner.getUploadedResourcesCache();
        this.domData = domData;
        this.userAgent = userAgent;
        this.checkSettings = checkSettings;
        this.checkTasks = checkTasks;
        this.renderingInfo = runner.getRenderingInfo();
        this.regionSelectors = regionSelectors;
        this.debugResourceWriter = debugResourceWriter;
        this.listener = listener;
        this.renderTaskListener = renderTaskListener;
    }

    @Override
    public TestResultContainer call() {
        try {
            DomAnalyzer domAnalyzer = new DomAnalyzer(this.logger, (UfgConnector)this.eyesConnector.getServerConnector(), this.debugResourceWriter, this.domData, this.resourcesCacheMap, this.userAgent);
            Map resourceMap = domAnalyzer.analyze();
            List<RenderRequest> renderRequests = this.buildRenderRequests(this.domData, resourceMap);
            if (this.debugResourceWriter != null && !(this.debugResourceWriter instanceof NullDebugResourceWriter)) {
                for (RenderRequest renderRequest : renderRequests) {
                    try {
                        this.debugResourceWriter.write(renderRequest.getDom().asResource());
                    }
                    catch (JsonProcessingException e) {
                        GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                    }
                    for (RGridResource value : renderRequest.getResources().values()) {
                        this.debugResourceWriter.write(value);
                    }
                }
            }
            this.logger.verbose("Uploading missing resources");
            List<RGridResource> missingResources = this.checkResourcesStatus(renderRequests.get(0).getDom(), resourceMap);
            this.uploadResources(missingResources);
            ArrayList<RenderingTask> renderingTasks = new ArrayList<RenderingTask>();
            for (int i = 0; i < renderRequests.size(); ++i) {
                VisualGridTask checkTask = this.checkTasks.get(i);
                checkTask.setRenderTaskCreated();
                renderingTasks.add(new RenderingTask(this.logger, this.eyesConnector, renderRequests.get(i), checkTask, this.renderTaskListener));
            }
            this.listener.onComplete(renderingTasks);
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)t);
            for (VisualGridTask checkTask : this.checkTasks) {
                checkTask.setExceptionAndAbort(t);
            }
            this.listener.onFail();
        }
        return null;
    }

    private List<RenderRequest> buildRenderRequests(FrameData result, Map<String, RGridResource> resourceMapping) {
        RGridDom dom = new RGridDom(result.getCdt(), resourceMapping, result.getUrl(), this.logger, "buildRenderRequests");
        ArrayList<RenderRequest> allRequestsForRG = new ArrayList<RenderRequest>();
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)((Object)this.checkSettings);
        ArrayList<VisualGridSelector> regionSelectorsList = new ArrayList<VisualGridSelector>();
        for (VisualGridSelector[] regionSelector : this.regionSelectors) {
            regionSelectorsList.addAll(Arrays.asList(regionSelector));
        }
        this.logger.verbose("region selectors count: " + regionSelectorsList.size());
        this.logger.verbose("check visual grid tasks count: " + this.checkTasks.size());
        for (VisualGridTask visualGridTask : this.checkTasks) {
            RenderBrowserInfo browserInfo = visualGridTask.getBrowserInfo();
            String sizeMode = checkSettingsInternal.getSizeMode();
            if (sizeMode.equalsIgnoreCase(VIEWPORT) && checkSettingsInternal.isStitchContent().booleanValue()) {
                sizeMode = FULLPAGE;
            }
            RenderInfo renderInfo = new RenderInfo(browserInfo.getWidth(), browserInfo.getHeight(), sizeMode, checkSettingsInternal.getTargetRegion(), checkSettingsInternal.getVGTargetSelector(), browserInfo.getEmulationInfo(), browserInfo.getIosDeviceInfo());
            RenderRequest request = new RenderRequest(this.renderingInfo.getResultsUrl(), result.getUrl(), dom, resourceMapping, renderInfo, browserInfo.getPlatform(), browserInfo.getBrowserType(), checkSettingsInternal.getScriptHooks(), regionSelectorsList, checkSettingsInternal.isSendDom(), visualGridTask, this.renderingInfo.getStitchingServiceUrl(), checkSettingsInternal.getVisualGridOptions());
            allRequestsForRG.add(request);
        }
        this.logger.verbose("count of all requests for RG: " + allRequestsForRG.size());
        return allRequestsForRG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RGridResource> checkResourcesStatus(RGridDom dom, Map<String, RGridResource> resourceMap) throws JsonProcessingException {
        Object resource2;
        ArrayList<HashObject> hashesToCheck = new ArrayList<HashObject>();
        HashMap<String, String> hashToResourceUrl = new HashMap<String, String>();
        for (Object resource2 : resourceMap.values()) {
            String url = resource2.getUrl();
            String hash = resource2.getSha256();
            String hashFormat = resource2.getHashFormat();
            Map<String, SyncTaskListener<Void>> map = this.uploadedResourcesCache;
            synchronized (map) {
                if (!this.uploadedResourcesCache.containsKey(hash)) {
                    hashesToCheck.add(new HashObject(hashFormat, hash));
                    hashToResourceUrl.put(hash, url);
                }
            }
        }
        RGridResource domResource = dom.asResource();
        resource2 = this.uploadedResourcesCache;
        synchronized (resource2) {
            if (!this.uploadedResourcesCache.containsKey(domResource.getSha256())) {
                hashesToCheck.add(new HashObject(domResource.getHashFormat(), domResource.getSha256()));
                hashToResourceUrl.put(domResource.getSha256(), domResource.getUrl());
            }
        }
        if (hashesToCheck.isEmpty()) {
            return new ArrayList<RGridResource>();
        }
        SyncTaskListener listener = new SyncTaskListener(this.logger, "checkResourceStatus");
        HashObject[] hashesArray = hashesToCheck.toArray(new HashObject[0]);
        this.eyesConnector.checkResourceStatus((TaskListener<Boolean[]>)listener, null, hashesArray);
        Boolean[] result = (Boolean[])listener.get();
        if (result == null) {
            throw new EyesException("Failed checking resources with the server");
        }
        ArrayList<RGridResource> missingResources = new ArrayList<RGridResource>();
        for (int i = 0; i < result.length; ++i) {
            String hash = hashesArray[i].getHash();
            String resourceUrl = (String)hashToResourceUrl.get(hash);
            if (result[i] != null && result[i].booleanValue()) {
                Map<String, SyncTaskListener<Void>> map = this.uploadedResourcesCache;
                synchronized (map) {
                    RGridResource resource3 = resourceUrl.equals(domResource.getUrl()) && hash.equals(domResource.getSha256()) ? domResource : resourceMap.get(resourceUrl);
                    resource3.resetContent();
                    this.uploadedResourcesCache.put(resource3.getSha256(), null);
                    continue;
                }
            }
            if (resourceUrl.equals(domResource.getUrl()) && hash.equals(domResource.getSha256())) {
                missingResources.add(domResource);
                continue;
            }
            missingResources.add(resourceMap.get(resourceUrl));
        }
        return missingResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uploadResources(List<RGridResource> resources) {
        for (RGridResource resource : resources) {
            Map<String, SyncTaskListener<Void>> map = this.uploadedResourcesCache;
            synchronized (map) {
                if (this.uploadedResourcesCache.containsKey(resource.getSha256())) {
                    continue;
                }
                this.logger.verbose("resource(" + resource.getUrl() + ") hash : " + resource.getSha256());
                SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("uploadResource %s %s", resource.getSha256(), resource.getUrl()));
                this.eyesConnector.renderPutResource("NONE", resource, (TaskListener<Void>)listener);
                this.uploadedResourcesCache.put(resource.getSha256(), (SyncTaskListener<Void>)listener);
            }
        }
        for (RGridResource resource : resources) {
            SyncTaskListener<Void> listener = this.uploadedResourcesCache.get(resource.getSha256());
            if (listener == null) continue;
            listener.get();
        }
    }
}

