/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatus;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class RenderingTask
implements Callable<RenderStatusResults> {
    public static final int HOUR = 3600000;
    private final RenderTaskListener listener;
    private final IEyesConnector eyesConnector;
    final List<RenderRequest> renderRequests = new ArrayList<RenderRequest>();
    private final List<VisualGridTask> checkTasks = new ArrayList<VisualGridTask>();
    private final Logger logger;
    private final Timer timer = new Timer("VG_StopWatch", true);
    private final AtomicBoolean isTimeElapsed = new AtomicBoolean(false);

    public RenderingTask(Logger logger, IEyesConnector eyesConnector, RenderRequest renderRequest, VisualGridTask checkTask, RenderTaskListener listener) {
        this.logger = logger;
        this.eyesConnector = eyesConnector;
        this.renderRequests.add(renderRequest);
        this.checkTasks.add(checkTask);
        this.listener = listener;
    }

    public void merge(RenderingTask renderingTask) {
        this.renderRequests.addAll(renderingTask.renderRequests);
        this.checkTasks.addAll(renderingTask.checkTasks);
    }

    @Override
    public RenderStatusResults call() {
        try {
            List<RunningRender> runningRenders;
            this.logger.verbose("enter");
            this.logger.verbose("Start rendering");
            RenderRequest[] asArray = this.renderRequests.toArray(new RenderRequest[0]);
            try {
                runningRenders = this.eyesConnector.render(asArray);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                this.logger.verbose("/render throws exception... sleeping for 1.5s");
                this.logger.verbose("ERROR " + e.getMessage());
                Thread.sleep(1500L);
                try {
                    runningRenders = this.eyesConnector.render(asArray);
                }
                catch (Exception e1) {
                    this.setRenderErrorToTasks();
                    throw new EyesException("Invalid response for render request", (Throwable)e1);
                }
            }
            this.logger.verbose("Validation render result");
            if (runningRenders == null || runningRenders.size() == 0) {
                this.setRenderErrorToTasks();
                throw new EyesException("Invalid response for render request");
            }
            for (int i = 0; i < this.renderRequests.size(); ++i) {
                RenderRequest request = this.renderRequests.get(i);
                request.setRenderId(runningRenders.get(i).getRenderId());
                this.logger.verbose(String.format("RunningRender: %s", runningRenders.get(i)));
            }
            for (RunningRender runningRender : runningRenders) {
                RenderStatus renderStatus = runningRender.getRenderStatus();
                if (renderStatus.equals((Object)RenderStatus.RENDERED) || renderStatus.equals((Object)RenderStatus.RENDERING)) continue;
                this.setRenderErrorToTasks();
                throw new EyesException(String.format("Invalid response for render request. Status: %s", renderStatus));
            }
            this.logger.verbose("Poll rendering status");
            Map<RunningRender, RenderRequest> mapping = this.mapRequestToRunningRender(runningRenders);
            this.pollRenderingStatus(mapping);
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            for (VisualGridTask checkTask : this.checkTasks) {
                checkTask.setExceptionAndAbort(e);
            }
            this.listener.onRenderFailed((Exception)new EyesException("Failed rendering", e));
        }
        this.logger.verbose("Finished rendering task - exit");
        return null;
    }

    private void setRenderErrorToTasks() {
        for (RenderRequest renderRequest : this.renderRequests) {
            renderRequest.getCheckTask().setRenderError(null, "Invalid response for render request");
        }
    }

    private Map<RunningRender, RenderRequest> mapRequestToRunningRender(List<RunningRender> runningRenders) {
        HashMap<RunningRender, RenderRequest> mapping = new HashMap<RunningRender, RenderRequest>();
        for (int i = 0; i < this.renderRequests.size(); ++i) {
            mapping.put(runningRenders.get(i), this.renderRequests.get(i));
        }
        return mapping;
    }

    private List<String> getRenderIds(Collection<RunningRender> runningRenders) {
        ArrayList<String> ids = new ArrayList<String>();
        for (RunningRender runningRender : runningRenders) {
            ids.add(runningRender.getRenderId());
        }
        return ids;
    }

    private void pollRenderingStatus(Map<RunningRender, RenderRequest> runningRenders) {
        this.logger.verbose("enter");
        List<String> ids = this.getRenderIds(runningRenders.keySet());
        this.logger.verbose("render ids : " + ids);
        this.timer.schedule((TimerTask)new TimeoutTask(), 3600000L);
        do {
            List<RenderStatusResults> renderStatusResultsList;
            try {
                renderStatusResultsList = this.eyesConnector.renderStatusById(ids.toArray(new String[0]));
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                continue;
            }
            if (renderStatusResultsList == null || renderStatusResultsList.isEmpty()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                }
                continue;
            }
            this.sampleRenderingStatus(runningRenders, ids, renderStatusResultsList);
            if (ids.size() <= 0) continue;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        } while (!ids.isEmpty() && !this.isTimeElapsed.get());
        this.timer.cancel();
        if (!ids.isEmpty()) {
            this.logger.verbose("Render ids that didn't complete in time : ");
            this.logger.verbose(ids.toString());
        }
        block7: for (String id : ids) {
            for (Map.Entry<RunningRender, RenderRequest> kvp : runningRenders.entrySet()) {
                RunningRender renderedRender = kvp.getKey();
                RenderRequest renderRequest = kvp.getValue();
                String renderId = renderedRender.getRenderId();
                if (!renderId.equalsIgnoreCase(id)) continue;
                this.logger.verbose("removing failed render id: " + id);
                VisualGridTask checkTask = renderRequest.getCheckTask();
                checkTask.setRenderError(id, "too long rendering(rendering exceeded 150 sec)");
                continue block7;
            }
        }
        this.logger.verbose("marking task as complete");
        this.listener.onRenderSuccess();
        this.logger.verbose("exit");
    }

    private void sampleRenderingStatus(Map<RunningRender, RenderRequest> runningRenders, List<String> ids, List<RenderStatusResults> renderStatusResultsList) {
        this.logger.verbose("enter - renderStatusResultsList.size: " + renderStatusResultsList.size());
        int j = 0;
        block0: for (int i = 0; i < renderStatusResultsList.size(); ++i) {
            RenderStatus renderStatus;
            RenderStatusResults renderStatusResults = renderStatusResultsList.get(i);
            if (renderStatusResults == null) {
                renderStatusResults = new RenderStatusResults();
                renderStatusResults.setStatus(RenderStatus.ERROR);
                renderStatusResults.setError("Render status result was null");
                renderStatusResults.setRenderId(ids.get(j));
            }
            boolean isRenderedStatus = (renderStatus = renderStatusResults.getStatus()) == RenderStatus.RENDERED;
            boolean isErrorStatus = renderStatus == RenderStatus.ERROR;
            this.logger.verbose("renderStatusResults - " + renderStatusResults);
            if (isRenderedStatus || isErrorStatus) {
                String removedId = ids.remove(j);
                for (Map.Entry<RunningRender, RenderRequest> kvp : runningRenders.entrySet()) {
                    RunningRender renderedRender = kvp.getKey();
                    RenderRequest renderRequest = kvp.getValue();
                    String renderId = renderedRender.getRenderId();
                    if (!renderId.equalsIgnoreCase(removedId)) continue;
                    VisualGridTask checkTask = renderRequest.getCheckTask();
                    this.logger.verbose("setting visualGridTask " + checkTask + " render result: " + renderStatusResults);
                    String error = renderStatusResults.getError();
                    if (error != null) {
                        GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)new Exception(error));
                        checkTask.setRenderError(renderId, error);
                        continue block0;
                    }
                    checkTask.setRenderResult(renderStatusResults);
                    continue block0;
                }
                continue;
            }
            ++j;
        }
        this.logger.verbose("exit");
    }

    public boolean isReady() {
        for (VisualGridTask checkTask : this.checkTasks) {
            if (checkTask.isReadyForRender()) continue;
            return false;
        }
        return true;
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            RenderingTask.this.logger.verbose("VG is Timed out!");
            RenderingTask.this.isTimeElapsed.set(true);
        }
    }

    public static interface RenderTaskListener {
        public void onRenderSuccess();

        public void onRenderFailed(Exception var1);
    }
}

