/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.ExactMatchSettings;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Region;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

public class ImageMatchSettings {
    private MatchLevel matchLevel;
    private ExactMatchSettings exact;
    private boolean ignoreCaret;
    private Region[] ignoreRegions;
    private Region[] layoutRegions;
    private Region[] strictRegions;
    private Region[] contentRegions;
    private FloatingMatchSettings[] floatingMatchSettings;
    private boolean useDom;
    public boolean enablePatterns;
    public boolean ignoreDisplacements;
    private AccessibilityRegionByRectangle[] accessibility = new AccessibilityRegionByRectangle[0];
    private AccessibilitySettings accessibilitySettings;

    public ImageMatchSettings(MatchLevel matchLevel, ExactMatchSettings exact, boolean useDom) {
        this.matchLevel = matchLevel;
        this.exact = exact;
        this.ignoreCaret = false;
        this.useDom = useDom;
    }

    public ImageMatchSettings() {
        this(MatchLevel.STRICT, null, false);
    }

    public ImageMatchSettings(ImageMatchSettings other) {
        if (other != null) {
            this.matchLevel = other.matchLevel;
            this.exact = other.exact == null ? null : new ExactMatchSettings(other.exact);
            this.ignoreCaret = other.ignoreCaret;
            this.ignoreRegions = other.ignoreRegions;
            this.layoutRegions = other.layoutRegions;
            this.strictRegions = other.strictRegions;
            this.contentRegions = other.contentRegions;
            this.floatingMatchSettings = other.floatingMatchSettings;
            this.useDom = other.useDom;
            this.enablePatterns = other.enablePatterns;
            this.ignoreDisplacements = other.ignoreDisplacements;
            this.accessibility = other.accessibility;
            this.accessibilitySettings = other.accessibilitySettings;
        } else {
            this.matchLevel = MatchLevel.STRICT;
        }
    }

    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.matchLevel = matchLevel;
    }

    public ExactMatchSettings getExact() {
        return this.exact;
    }

    public void setExact(ExactMatchSettings exact) {
        this.exact = exact;
    }

    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    public boolean isUseDom() {
        return this.useDom;
    }

    public void setUseDom(boolean useDom) {
        this.useDom = useDom;
    }

    @JsonSetter(value="Ignore")
    public void setIgnoreRegions(Region[] ignoreRegions) {
        this.ignoreRegions = ignoreRegions;
    }

    @JsonSetter(value="Layout")
    public void setLayoutRegions(Region[] layoutRegions) {
        this.layoutRegions = layoutRegions;
    }

    @JsonSetter(value="Strict")
    public void setStrictRegions(Region[] strictRegions) {
        this.strictRegions = strictRegions;
    }

    @JsonSetter(value="Content")
    public void setContentRegions(Region[] contentRegions) {
        this.contentRegions = contentRegions;
    }

    @JsonGetter(value="Ignore")
    public Region[] getIgnoreRegions() {
        return this.ignoreRegions;
    }

    @JsonGetter(value="Strict")
    public Region[] getStrictRegions() {
        return this.strictRegions;
    }

    @JsonGetter(value="Layout")
    public Region[] getLayoutRegions() {
        return this.layoutRegions;
    }

    @JsonGetter(value="Content")
    public Region[] getContentRegions() {
        return this.contentRegions;
    }

    @JsonSetter(value="Floating")
    public void setFloatingRegions(FloatingMatchSettings[] floatingRegions) {
        this.floatingMatchSettings = floatingRegions;
    }

    @JsonGetter(value="Floating")
    public FloatingMatchSettings[] getFloatingRegions() {
        return this.floatingMatchSettings;
    }

    public void setIgnoreCaret(Boolean ignoreCaret) {
        this.ignoreCaret = ignoreCaret;
    }

    public String toString() {
        return String.format("Match level: %s, Exact match settings: %s", new Object[]{this.matchLevel, this.exact});
    }

    public boolean isEnablePatterns() {
        return this.enablePatterns;
    }

    public void setEnablePatterns(boolean enablePatterns) {
        this.enablePatterns = enablePatterns;
    }

    public void setIgnoreDisplacements(boolean ignoreDisplacements) {
        this.ignoreDisplacements = ignoreDisplacements;
    }

    public boolean isIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    public void setAccessibility(AccessibilityRegionByRectangle[] accessibilityValidation) {
        this.accessibility = accessibilityValidation;
    }

    public AccessibilitySettings getAccessibilitySettings() {
        return this.accessibilitySettings;
    }

    public void setAccessibilitySettings(AccessibilitySettings accessibilitySettings) {
        this.accessibilitySettings = accessibilitySettings;
    }

    public AccessibilityRegionByRectangle[] getAccessibility() {
        return this.accessibility;
    }
}

