/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.LogHandler;
import com.applitools.utils.ArgumentGuard;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class FileLogger
extends LogHandler {
    private final String filename;
    private final boolean append;
    private BufferedWriter fileWriter;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public FileLogger(String filename, boolean append, boolean isVerbose) {
        super(isVerbose);
        ArgumentGuard.notNullOrEmpty((String)filename, (String)"filename");
        this.filename = filename;
        this.append = append;
        this.fileWriter = null;
    }

    public FileLogger(boolean isVerbose) {
        this("eyes.log", true, isVerbose);
    }

    public void open() {
        if (this.fileWriter != null) {
            return;
        }
        try {
            File file = new File(this.filename);
            File path = file.getParentFile();
            if (path != null && !path.exists()) {
                System.out.println("No Folder");
                boolean success = path.mkdirs();
                if (success) {
                    System.out.println("Folder created");
                } else {
                    System.out.printf("Failed creating folder %s%n", path.getAbsolutePath());
                }
            }
            this.fileWriter = new BufferedWriter(new FileWriter(file, this.append));
        }
        catch (IOException e) {
            throw new EyesException("Failed to create log file!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onMessage(String message) {
        if (this.fileWriter != null) {
            BufferedWriter bufferedWriter = this.fileWriter;
            synchronized (bufferedWriter) {
                try {
                    this.fileWriter.write(this.getFormattedTimeStamp() + " Eyes: " + message);
                    this.fileWriter.newLine();
                    this.fileWriter.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void close() {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileWriter = null;
    }

    public boolean isOpen() {
        return this.fileWriter != null;
    }

    private String getFormattedTimeStamp() {
        return this.dateFormat.format(Calendar.getInstance().getTime());
    }
}

