/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.utils.GeneralUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class EyesRunner {
    private TestResultsSummary allTestResults = null;
    private boolean dontCloseBatches = false;
    protected Logger logger = new IdPrintingLogger("n/a");
    private final Map<String, IBatchCloser> batchesServerConnectorsMap = new HashMap<String, IBatchCloser>();

    public abstract TestResultsSummary getAllTestResultsImpl();

    public abstract TestResultsSummary getAllTestResultsImpl(boolean var1);

    public TestResultsSummary getAllTestResults() {
        return this.getAllTestResults(true);
    }

    public TestResultsSummary getAllTestResults(boolean shouldThrowException) {
        this.logger.verbose("enter");
        if (this.allTestResults != null) {
            this.logger.log("WARNING: getAllTestResults called more than once");
            return this.allTestResults;
        }
        try {
            this.allTestResults = this.getAllTestResultsImpl(shouldThrowException);
        }
        finally {
            this.deleteAllBatches();
        }
        return this.allTestResults;
    }

    private void deleteAllBatches() {
        if (this.dontCloseBatches) {
            return;
        }
        boolean dontCloseBatchesStr = GeneralUtils.getDontCloseBatches();
        if (dontCloseBatchesStr) {
            this.logger.log("APPLITOOLS_DONT_CLOSE_BATCHES environment variable set to true. Skipping batch close.");
            return;
        }
        this.logger.verbose(String.format("Deleting %d batches", this.batchesServerConnectorsMap.size()));
        for (String batch : this.batchesServerConnectorsMap.keySet()) {
            IBatchCloser connector = this.batchesServerConnectorsMap.get(batch);
            connector.closeBatch(batch);
        }
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
        if (!logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public void setDontCloseBatches(boolean dontCloseBatches) {
        this.dontCloseBatches = dontCloseBatches;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addBatch(String batchId, IBatchCloser batchCloser) {
        if (!this.batchesServerConnectorsMap.containsKey(batchId)) {
            this.batchesServerConnectorsMap.put(batchId, batchCloser);
        }
    }

    protected static class IdPrintingLogger
    extends Logger {
        protected final String runnerId = UUID.randomUUID().toString();
        protected final String suiteName;

        public IdPrintingLogger(String suiteName) {
            this.suiteName = suiteName;
        }

        protected int getMethodsBack() {
            return 4;
        }

        public String getPrefix() {
            return super.getPrefix() + this.suiteName + " (runnerId: " + this.runnerId + ") ";
        }
    }
}

