/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowDataWithScreenshot;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ServerConnector;
import com.applitools.utils.BlockingInstanceContainer;

public class ResponseTimeMatchFinderTask
implements Runnable {
    private final long matchInterval;
    private final ServerConnector serverConnector;
    private final RunningSession runningSession;
    private final BlockingInstanceContainer<MatchWindowDataWithScreenshot> matchDataContainer;
    private MatchWindowDataWithScreenshot lastNonMatch;
    private MatchWindowDataWithScreenshot theMatch;
    private EyesScreenshot lastScreenshot;

    public ResponseTimeMatchFinderTask(BlockingInstanceContainer<MatchWindowDataWithScreenshot> matchDataContainer, long matchInterval, ServerConnector serverConnector, RunningSession runningSession) {
        this.matchDataContainer = matchDataContainer;
        this.matchInterval = matchInterval;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.theMatch = null;
        this.lastNonMatch = null;
        this.lastScreenshot = null;
    }

    @Override
    public void run() {
        MatchWindowDataWithScreenshot currentMatchData = (MatchWindowDataWithScreenshot)this.matchDataContainer.take();
        if (currentMatchData == null) {
            return;
        }
        this.lastScreenshot = currentMatchData.getScreenshot();
        long lastMatchAttemptTime = System.currentTimeMillis();
        MatchResult matchResult = this.serverConnector.matchWindow(this.runningSession, currentMatchData.getMatchWindowData());
        while (!matchResult.getAsExpected() && !Thread.interrupted()) {
            this.lastNonMatch = currentMatchData;
            currentMatchData = (MatchWindowDataWithScreenshot)this.matchDataContainer.take();
            if (currentMatchData == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long timeToSleep = this.matchInterval - (currentTime - lastMatchAttemptTime);
            if (timeToSleep > 0L) {
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            this.lastScreenshot = currentMatchData.getScreenshot();
            lastMatchAttemptTime = System.currentTimeMillis();
            matchResult = this.serverConnector.matchWindow(this.runningSession, currentMatchData.getMatchWindowData());
        }
        if (matchResult.getAsExpected()) {
            this.theMatch = currentMatchData;
        } else {
            this.lastNonMatch = currentMatchData;
        }
    }

    public MatchWindowDataWithScreenshot getTheMatch() {
        return this.theMatch;
    }

    public MatchWindowDataWithScreenshot getLastNonMatch() {
        return this.lastNonMatch;
    }

    public EyesScreenshot getLastScreenshot() {
        return this.lastScreenshot;
    }
}

