/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppOutput;
import com.applitools.eyes.AppOutputProvider;
import com.applitools.eyes.AppOutputWithScreenshot;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.MatchWindowDataWithScreenshot;
import com.applitools.eyes.RegionProvider;
import com.applitools.eyes.ResponseTimeInitialMatchSearchResult;
import com.applitools.eyes.ResponseTimeMatchFinderTask;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ServerConnector;
import com.applitools.eyes.TimedAppOutput;
import com.applitools.eyes.Trigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.BlockingInstanceContainer;
import com.applitools.utils.GeneralUtils;
import java.util.LinkedList;
import java.util.List;

public class ResponseTimeAlgorithm {
    private static final int FAST_INTERVAL_SCREENSHOTS_COUNT = 10;
    private static final int STANDARD_INTERVAL_SCREENSHOTS_COUNT = 20;

    private static String createTagForDeadline(int deadline, long elapsedTime) {
        String tag = elapsedTime < (long)deadline ? String.format("After %d seconds (%d seconds to deadline)", elapsedTime, (long)deadline - elapsedTime) : (elapsedTime > (long)deadline ? String.format("After %d seconds (%d seconds after deadline)", elapsedTime, elapsedTime - (long)deadline) : String.format("After %d seconds (deadline)", elapsedTime));
        return tag;
    }

    private static MatchWindowDataWithScreenshot cloneTimedMWDWSWithPrimary(MatchWindowDataWithScreenshot currentMwdws, boolean updatePrimary) {
        MatchWindowData currentMwd = currentMwdws.getMatchWindowData();
        TimedAppOutput currentAppOutput = (TimedAppOutput)currentMwdws.getMatchWindowData().getAppOutput();
        TimedAppOutput updatedAppOutput = new TimedAppOutput(currentAppOutput.getTitle(), currentAppOutput.getScreenshot64(), currentAppOutput.getElapsed(), updatePrimary);
        MatchWindowData updatedMwd = new MatchWindowData(currentMwd.getUserInputs(), (AppOutput)updatedAppOutput, currentMwd.getTag(), currentMwd.getIgnoreMismatch(), currentMwd.getOptions());
        return new MatchWindowDataWithScreenshot(updatedMwd, currentMwdws.getScreenshot());
    }

    public static void runNewProgressionSession(Logger logger, ServerConnector serverConnector, RunningSession runningSession, AppOutputProvider appOutputProvider, RegionProvider regionProvider, long startTime, int deadline) {
        logger.verbose("New progression session detected.");
        logger.verbose("Waiting for deadline to create the baseline...");
        try {
            Thread.sleep(deadline * 1000);
            logger.verbose("Finished waiting for deadline.");
        }
        catch (InterruptedException e) {
            logger.verbose("Got interrupted while waiting for deadline to pass!");
        }
        logger.verbose("Taking screenshot...");
        AppOutputWithScreenshot appOutputWithScreenshot = appOutputProvider.getAppOutput(regionProvider.getRegion(), null);
        logger.verbose("Screenshot taken.");
        long elapsedTime = GeneralUtils.getFullSecondsElapsedTimeMillis((long)startTime, (long)System.currentTimeMillis());
        logger.verbose("Saving screenshot...");
        AppOutput appOutput = appOutputWithScreenshot.getAppOutput();
        TimedAppOutput timedAppOutput = new TimedAppOutput(appOutput.getTitle(), appOutput.getScreenshot64(), elapsedTime, true);
        String tag = appOutput.getTitle();
        Trigger[] noUserInputs = new Trigger[]{};
        MatchWindowData mwd = new MatchWindowData(noUserInputs, (AppOutput)timedAppOutput, tag, true, new MatchWindowData.Options(tag, noUserInputs, false, false, false, false, null));
        serverConnector.matchWindow(runningSession, mwd);
        logger.verbose("Finished saving.");
        logger.verbose("testResponseTimeBase Done!");
    }

    private static ResponseTimeInitialMatchSearchResult responseTimeInitialMatchSearch(Logger logger, ServerConnector serverConnector, RunningSession runningSession, AppOutputProvider appOutputProvider, RegionProvider regionProvider, long startTime, int deadline, int timeout, long matchInterval, List<MatchWindowDataWithScreenshot> collectedData) {
        logger.verbose("responseTimeInitialMatchSearch()");
        long MIN_SCREENSHOT_INTERVAL = 1000L;
        long MATCH_THREAD_CLOSE_TIMEOUT = 10000L;
        int fastIntervalTimeout = timeout - 10;
        if (fastIntervalTimeout < 0) {
            fastIntervalTimeout = 0;
        }
        logger.verbose("fast interval timeout: " + fastIntervalTimeout);
        long screenshotInterval = 1000L;
        if (fastIntervalTimeout > 0) {
            screenshotInterval = (long)Math.ceil((float)fastIntervalTimeout / 20.0f) * 1000L;
        }
        logger.verbose("Screenshot interval (Milliseconds): " + screenshotInterval);
        int maxScreenshotsCount = 30;
        BlockingInstanceContainer matchDataContainer = new BlockingInstanceContainer();
        logger.verbose("Starting matcher thread.");
        ResponseTimeMatchFinderTask matcherTask = new ResponseTimeMatchFinderTask((BlockingInstanceContainer<MatchWindowDataWithScreenshot>)matchDataContainer, matchInterval, serverConnector, runningSession);
        Thread matcherTaskThread = new Thread(matcherTask);
        matcherTaskThread.start();
        long currentTime = System.currentTimeMillis();
        long elapsedTime = GeneralUtils.getFullSecondsElapsedTimeMillis((long)startTime, (long)currentTime);
        boolean switchedToFastInterval = false;
        boolean markedPrimary = false;
        boolean isPrimary = false;
        MatchWindowDataWithScreenshot theMatch = null;
        MatchWindowDataWithScreenshot originalPrimary = null;
        MatchWindowDataWithScreenshot updatedPrimary = null;
        int screenshotsCount = 0;
        long deadlineMs = deadline * 1000;
        long timeoutMs = timeout * 1000;
        long fastIntervalTimeoutMs = fastIntervalTimeout * 1000;
        while (theMatch == null && screenshotsCount < maxScreenshotsCount && elapsedTime < timeoutMs) {
            if (!switchedToFastInterval && elapsedTime >= fastIntervalTimeoutMs) {
                screenshotInterval = 1000L;
                switchedToFastInterval = true;
                logger.verbose("Switched to fast interval.");
            }
            logger.verbose("Taking screenshot...");
            long lastScreenshotRequestTime = System.currentTimeMillis();
            AppOutputWithScreenshot appOutputWithScreenshot = appOutputProvider.getAppOutput(regionProvider.getRegion(), matcherTask.getLastScreenshot());
            elapsedTime = GeneralUtils.getFullSecondsElapsedTimeMillis((long)startTime, (long)System.currentTimeMillis());
            logger.verbose("Screenshot taken!");
            if (!markedPrimary && elapsedTime > deadlineMs) {
                if (collectedData.size() != 0) {
                    logger.verbose("Previous screenshot is primary.");
                    originalPrimary = collectedData.get(collectedData.size() - 1);
                    updatedPrimary = ResponseTimeAlgorithm.cloneTimedMWDWSWithPrimary(originalPrimary, true);
                    collectedData.set(collectedData.size() - 1, updatedPrimary);
                } else {
                    isPrimary = true;
                    logger.verbose("current screenshot is primary.");
                }
                markedPrimary = true;
            }
            AppOutput appOutput = appOutputWithScreenshot.getAppOutput();
            TimedAppOutput timedAppOutput = new TimedAppOutput(appOutput.getTitle(), appOutput.getScreenshot64(), elapsedTime, isPrimary);
            isPrimary = false;
            int elapsedSeconds = (int)Math.floor((double)elapsedTime / 1000.0);
            String tag = ResponseTimeAlgorithm.createTagForDeadline(deadline, elapsedSeconds);
            Trigger[] noUserInputs = new Trigger[]{};
            MatchWindowData currentWindowData = new MatchWindowData(noUserInputs, (AppOutput)timedAppOutput, tag, true, new MatchWindowData.Options(tag, noUserInputs, true, true, false, false, null));
            MatchWindowDataWithScreenshot currentWindowDataWithScreenshot = new MatchWindowDataWithScreenshot(currentWindowData, appOutputWithScreenshot.getScreenshot());
            ++screenshotsCount;
            collectedData.add(collectedData.size(), currentWindowDataWithScreenshot);
            matchDataContainer.put((Object)currentWindowDataWithScreenshot);
            theMatch = matcherTask.getTheMatch();
            if (theMatch == null) {
                long timeToSleep = screenshotInterval - (System.currentTimeMillis() - lastScreenshotRequestTime);
                logger.verbose("No match yet.");
                if (timeToSleep > 0L) {
                    logger.verbose("Time to sleep: " + timeToSleep);
                    try {
                        Thread.sleep(timeToSleep);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            currentTime = System.currentTimeMillis();
            elapsedTime = GeneralUtils.getFullSecondsElapsedTimeMillis((long)startTime, (long)currentTime);
        }
        logger.verbose("Finished collecting data.");
        matchDataContainer.close();
        if (theMatch == null) {
            logger.verbose("No match found yet. Waiting for matcher thread..");
            try {
                matcherTaskThread.join(10000L);
                logger.verbose("Finished waiting.");
                if (matcherTaskThread.isAlive()) {
                    logger.verbose("Matcher thread still running. Interrupting it..");
                    matcherTaskThread.interrupt();
                    logger.verbose("Done!");
                }
            }
            catch (InterruptedException e) {
                logger.verbose("Got interrupt while Waiting for matcher thread.");
            }
            theMatch = matcherTask.getTheMatch();
        }
        MatchWindowDataWithScreenshot lastNonMatch = matcherTask.getLastNonMatch();
        if (theMatch == originalPrimary) {
            theMatch = updatedPrimary;
        } else if (lastNonMatch == originalPrimary) {
            lastNonMatch = updatedPrimary;
        }
        logger.verbose("Is match found? " + (theMatch != null));
        return new ResponseTimeInitialMatchSearchResult(theMatch, lastNonMatch);
    }

    private static int binarySearchEarliestMatch(Logger logger, ServerConnector serverConnector, RunningSession runningSession, List<MatchWindowDataWithScreenshot> dataToSearch, int fromIndex, int toIndex, int earliestMatchIndex) {
        logger.verbose(String.format("Indices: From %d, to %s ", fromIndex, toIndex));
        if (fromIndex > toIndex) {
            throw new EyesException(String.format("Invalid indices: From %d, to %s ", fromIndex, toIndex));
        }
        int currentMatchIndex = (int)Math.ceil((double)(fromIndex + toIndex) / 2.0);
        logger.verbose("Trying to match index: " + currentMatchIndex);
        MatchResult matchResult = serverConnector.matchWindow(runningSession, dataToSearch.get(currentMatchIndex).getMatchWindowData());
        if (matchResult.getAsExpected()) {
            logger.verbose("Match!");
            earliestMatchIndex = currentMatchIndex;
        } else {
            logger.verbose("No match!");
        }
        if (fromIndex == toIndex || toIndex == currentMatchIndex && !matchResult.getAsExpected()) {
            logger.verbose(String.format("Finished matching! Current index: %d, earliest match: %d", currentMatchIndex, earliestMatchIndex));
            return earliestMatchIndex;
        }
        if (matchResult.getAsExpected()) {
            toIndex = currentMatchIndex - 1;
        } else {
            fromIndex = currentMatchIndex + 1;
        }
        return ResponseTimeAlgorithm.binarySearchEarliestMatch(logger, serverConnector, runningSession, dataToSearch, fromIndex, toIndex, earliestMatchIndex);
    }

    private static int findEarliestMatchIndex(Logger logger, ServerConnector serverConnector, RunningSession runningSession, List<MatchWindowDataWithScreenshot> collectedData, MatchWindowDataWithScreenshot theMatch, MatchWindowDataWithScreenshot lastNonMatch) {
        if (theMatch == null) {
            return -1;
        }
        logger.verbose("findEarliestMatchIndex()");
        int theMatchIndex = collectedData.indexOf(theMatch);
        if (theMatchIndex == 0) {
            return 0;
        }
        int lastNonMatchIndex = lastNonMatch != null ? collectedData.indexOf(lastNonMatch) : 0;
        logger.verbose(String.format("Performing binary search for earliest match: From %d to %d", lastNonMatchIndex, theMatchIndex - 1));
        theMatchIndex = ResponseTimeAlgorithm.binarySearchEarliestMatch(logger, serverConnector, runningSession, collectedData, lastNonMatchIndex, theMatchIndex - 1, theMatchIndex);
        logger.verbose("The earliest match index: " + theMatchIndex);
        return theMatchIndex;
    }

    private static MatchWindowDataWithScreenshot updatePrimary(Logger logger, List<MatchWindowDataWithScreenshot> collectedData, int theMatchIndex, int deadline) {
        long deadlineMs;
        logger.verbose("updatedPrimary()");
        if (theMatchIndex < 0) {
            logger.verbose("No match exists. No update is necessary.");
            return null;
        }
        MatchWindowDataWithScreenshot theMatch = collectedData.get(theMatchIndex);
        TimedAppOutput tao = (TimedAppOutput)theMatch.getMatchWindowData().getAppOutput();
        long matchElapsed = tao.getElapsed();
        if (matchElapsed <= (deadlineMs = (long)(deadline * 1000))) {
            logger.verbose("Match is within the deadline.");
            logger.verbose("Searching for primary...");
            for (int i = theMatchIndex + 1; i < collectedData.size(); ++i) {
                MatchWindowDataWithScreenshot currentMwdws = collectedData.get(i);
                TimedAppOutput currentAppOutput = (TimedAppOutput)currentMwdws.getMatchWindowData().getAppOutput();
                if (!currentAppOutput.getIsPrimary()) continue;
                logger.verbose("Found primary at index " + i);
                MatchWindowDataWithScreenshot updatedMwdws = ResponseTimeAlgorithm.cloneTimedMWDWSWithPrimary(currentMwdws, false);
                logger.verbose("Un-marking original primary.");
                collectedData.set(i, updatedMwdws);
                break;
            }
            logger.verbose(String.format("Marking the earliest match as primary (at index %d).", theMatchIndex));
            theMatch = ResponseTimeAlgorithm.cloneTimedMWDWSWithPrimary(theMatch, true);
            collectedData.set(theMatchIndex, theMatch);
        }
        return theMatch;
    }

    private static void setProgressionImages(Logger logger, ServerConnector serverConnector, RunningSession runningSession, List<MatchWindowDataWithScreenshot> collectedData, int theMatchIndex) {
        MatchWindowData mwdToSend;
        MatchWindowData.Options currentOptions;
        MatchWindowData currentMwd;
        MatchWindowDataWithScreenshot currentMwdws;
        logger.verbose("setProgressionImages()");
        logger.verbose("The match index: " + theMatchIndex);
        int lastImageIndex = theMatchIndex > -1 ? theMatchIndex : collectedData.size() - 1;
        logger.verbose("Last image index: " + lastImageIndex);
        logger.verbose("Setting images...");
        for (int i = 0; i < lastImageIndex; ++i) {
            long nextElapsed;
            currentMwdws = collectedData.get(i);
            currentMwd = currentMwdws.getMatchWindowData();
            currentOptions = currentMwd.getOptions();
            long currentElapsed = ((TimedAppOutput)currentMwd.getAppOutput()).getElapsed();
            if (currentElapsed == (nextElapsed = ((TimedAppOutput)collectedData.get(i + 1).getMatchWindowData().getAppOutput()).getElapsed())) {
                logger.verbose(String.format("Skipping image at index %d (same elapsed as next image)...", i));
                if (!((TimedAppOutput)currentMwd.getAppOutput()).getIsPrimary()) continue;
                logger.verbose("Skipped image is primary..");
                logger.verbose("Moving primary to the next image..");
                MatchWindowDataWithScreenshot nextMatchData = collectedData.get(i + 1);
                nextMatchData = ResponseTimeAlgorithm.cloneTimedMWDWSWithPrimary(nextMatchData, true);
                collectedData.set(i + 1, nextMatchData);
                logger.verbose("Done moving primary.");
                continue;
            }
            mwdToSend = new MatchWindowData(currentMwd.getUserInputs(), currentMwd.getAppOutput(), currentMwd.getTag(), false, new MatchWindowData.Options(currentOptions.getName(), currentOptions.getUserInputs(), false, false, true, false, null));
            serverConnector.matchWindow(runningSession, mwdToSend);
        }
        boolean forceMatch = theMatchIndex > -1;
        logger.verbose("Setting last image as a match? " + forceMatch);
        currentMwdws = collectedData.get(lastImageIndex);
        currentMwd = currentMwdws.getMatchWindowData();
        currentOptions = currentMwd.getOptions();
        mwdToSend = new MatchWindowData(currentMwd.getUserInputs(), currentMwd.getAppOutput(), currentMwd.getTag(), false, new MatchWindowData.Options(currentOptions.getName(), currentOptions.getUserInputs(), false, false, !forceMatch, forceMatch, null));
        serverConnector.matchWindow(runningSession, mwdToSend);
        logger.verbose("Done setting images!");
    }

    public static MatchWindowDataWithScreenshot runProgressionSessionForExistingBaseline(Logger logger, ServerConnector serverConnector, RunningSession runningSession, AppOutputProvider appOutputProvider, RegionProvider regionProvider, long startTime, int deadline, int timeout, long matchInterval) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.notNull((Object)appOutputProvider, (String)"appOutputProvider");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        ArgumentGuard.greaterThanOrEqualToZero((long)startTime, (String)"startTime");
        ArgumentGuard.greaterThanOrEqualToZero((long)deadline, (String)"deadline");
        ArgumentGuard.greaterThanOrEqualToZero((long)timeout, (String)"timeout");
        ArgumentGuard.greaterThanOrEqualToZero((long)matchInterval, (String)"matchInterval");
        logger.verbose("runProgressionSessionForExistingBaseline()");
        LinkedList<MatchWindowDataWithScreenshot> collectedData = new LinkedList<MatchWindowDataWithScreenshot>();
        ResponseTimeInitialMatchSearchResult initialSearchResult = ResponseTimeAlgorithm.responseTimeInitialMatchSearch(logger, serverConnector, runningSession, appOutputProvider, regionProvider, startTime, deadline, timeout, matchInterval, collectedData);
        MatchWindowDataWithScreenshot theMatch = initialSearchResult.getTheMatch();
        MatchWindowDataWithScreenshot lastNonMatch = initialSearchResult.getLastNonMatch();
        logger.verbose("Finished initial search!");
        logger.verbose("No. of screenshots: " + collectedData.size());
        logger.verbose("Is match found? " + (theMatch != null));
        if (theMatch != null) {
            logger.verbose("Initial known match index: " + collectedData.indexOf(theMatch));
        }
        logger.verbose("Searching for the earliest match..");
        int theMatchIndex = ResponseTimeAlgorithm.findEarliestMatchIndex(logger, serverConnector, runningSession, collectedData, theMatch, lastNonMatch);
        logger.verbose("Done! Earliest match index: " + theMatchIndex);
        theMatch = ResponseTimeAlgorithm.updatePrimary(logger, collectedData, theMatchIndex, deadline);
        ResponseTimeAlgorithm.setProgressionImages(logger, serverConnector, runningSession, collectedData, theMatchIndex);
        logger.verbose("Done!");
        return theMatch;
    }
}

