/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppOutputProvider;
import com.applitools.eyes.AppOutputWithScreenshot;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ServerConnector;
import com.applitools.eyes.Trigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.awt.image.BufferedImage;

public class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private final Logger logger;
    private final ServerConnector serverConnector;
    private final RunningSession runningSession;
    private final int defaultRetryTimeout;
    private final AppOutputProvider appOutputProvider;
    private EyesScreenshot lastScreenshot = null;
    private MatchResult matchResult;
    private Region lastScreenshotBounds;

    public MatchWindowTask(Logger logger, ServerConnector serverConnector, RunningSession runningSession, int retryTimeout, AppOutputProvider appOutputProvider) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        ArgumentGuard.notNull((Object)appOutputProvider, (String)"appOutputProvider");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout;
        this.appOutputProvider = appOutputProvider;
    }

    protected MatchResult performMatch(Trigger[] userInputs, AppOutputWithScreenshot appOutput, String tag, boolean ignoreMismatch, ImageMatchSettings imageMatchSettings) {
        MatchWindowData data = new MatchWindowData(userInputs, appOutput.getAppOutput(), tag, ignoreMismatch, new MatchWindowData.Options(tag, userInputs, ignoreMismatch, false, false, false, imageMatchSettings));
        return this.serverConnector.matchWindow(this.runningSession, data);
    }

    public MatchResult matchWindow(Trigger[] userInputs, Region region, String tag, boolean shouldRunOnceOnTimeout, boolean ignoreMismatch, ImageMatchSettings imageMatchSettings, int retryTimeout) {
        if (retryTimeout < 0) {
            retryTimeout = this.defaultRetryTimeout;
        }
        this.logger.verbose(String.format("retryTimeout = %d", retryTimeout));
        EyesScreenshot screenshot = this.takeScreenshot(userInputs, region, tag, shouldRunOnceOnTimeout, ignoreMismatch, imageMatchSettings, retryTimeout);
        if (ignoreMismatch) {
            return this.matchResult;
        }
        this.updateLastScreenshot(screenshot);
        this.updateBounds(region);
        return this.matchResult;
    }

    private EyesScreenshot takeScreenshot(Trigger[] userInputs, Region region, String tag, boolean shouldMatchWindowRunOnceOnTimeout, boolean ignoreMismatch, ImageMatchSettings imageMatchSettings, int retryTimeout) {
        EyesScreenshot screenshot;
        long elapsedTimeStart = System.currentTimeMillis();
        if (0 == retryTimeout || shouldMatchWindowRunOnceOnTimeout) {
            if (shouldMatchWindowRunOnceOnTimeout) {
                GeneralUtils.sleep((long)retryTimeout);
            }
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, ignoreMismatch, imageMatchSettings);
        } else {
            screenshot = this.retryTakingScreenshot(userInputs, region, tag, ignoreMismatch, imageMatchSettings, retryTimeout);
        }
        double elapsedTime = (System.currentTimeMillis() - elapsedTimeStart) / 1000L;
        this.logger.verbose(String.format("Completed in %.2f seconds", elapsedTime));
        return screenshot;
    }

    private EyesScreenshot retryTakingScreenshot(Trigger[] userInputs, Region region, String tag, boolean ignoreMismatch, ImageMatchSettings imageMatchSettings, int retryTimeout) {
        long start = System.currentTimeMillis();
        EyesScreenshot screenshot = null;
        long retry = System.currentTimeMillis() - start;
        while (retry < (long)retryTimeout) {
            GeneralUtils.sleep((long)500L);
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, true, imageMatchSettings);
            if (this.matchResult.getAsExpected()) break;
            retry = System.currentTimeMillis() - start;
        }
        if (!this.matchResult.getAsExpected()) {
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, ignoreMismatch, imageMatchSettings);
        }
        return screenshot;
    }

    private EyesScreenshot tryTakeScreenshot(Trigger[] userInputs, Region region, String tag, boolean ignoreMismatch, ImageMatchSettings imageMatchSettings) {
        AppOutputWithScreenshot appOutput = this.appOutputProvider.getAppOutput(region, this.lastScreenshot);
        EyesScreenshot screenshot = appOutput.getScreenshot();
        this.matchResult = this.performMatch(userInputs, appOutput, tag, ignoreMismatch, imageMatchSettings);
        return screenshot;
    }

    private void updateLastScreenshot(EyesScreenshot screenshot) {
        if (screenshot != null) {
            this.lastScreenshot = screenshot;
        }
    }

    private void updateBounds(Region region) {
        if (region.isEmpty()) {
            if (this.lastScreenshot == null) {
                this.lastScreenshotBounds = new Region(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else {
                BufferedImage image = this.lastScreenshot.getImage();
                this.lastScreenshotBounds = new Region(0, 0, image.getWidth(), image.getHeight());
            }
        } else {
            this.lastScreenshotBounds = region;
        }
    }

    public Region getLastScreenshotBounds() {
        return this.lastScreenshotBounds;
    }
}

