/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.IGetAccessibilityRegion;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckSettings
implements ICheckSettings,
ICheckSettingsInternal {
    protected static final String BEFORE_CAPTURE_SCREENSHOT = "beforeCaptureScreenshot";
    private Region targetRegion;
    private MatchLevel matchLevel = null;
    private Boolean ignoreCaret = null;
    private Boolean stitchContent = null;
    private List<GetRegion> ignoreRegions = new ArrayList<GetRegion>();
    private List<GetRegion> layoutRegions = new ArrayList<GetRegion>();
    private List<GetRegion> strictRegions = new ArrayList<GetRegion>();
    private List<GetRegion> contentRegions = new ArrayList<GetRegion>();
    private List<GetFloatingRegion> floatingRegions = new ArrayList<GetFloatingRegion>();
    private int timeout = -1;
    protected String name;
    protected Boolean enablePatterns;
    protected Boolean sendDom = null;
    protected Boolean useDom;
    protected Map<String, String> scriptHooks = new HashMap<String, String>();
    protected Boolean ignoreDisplacements;
    protected List<IGetAccessibilityRegion> accessibilityRegions = new ArrayList<IGetAccessibilityRegion>();

    protected CheckSettings() {
    }

    protected CheckSettings(Region region) {
        this.targetRegion = region;
    }

    public CheckSettings(int timeout) {
        this.timeout = timeout;
    }

    protected void ignore_(Region region) {
        this.ignore_(new SimpleRegionByRectangle(region));
    }

    protected void ignore_(GetRegion regionProvider) {
        this.ignoreRegions.add(regionProvider);
    }

    protected void layout_(Region region) {
        this.layout_(new SimpleRegionByRectangle(region));
    }

    protected void layout_(GetRegion regionProvider) {
        this.layoutRegions.add(regionProvider);
    }

    protected void content_(Region region) {
        this.content_(new SimpleRegionByRectangle(region));
    }

    protected void content_(GetRegion regionProvider) {
        this.contentRegions.add(regionProvider);
    }

    protected void strict_(Region region) {
        this.strict_(new SimpleRegionByRectangle(region));
    }

    protected void strict_(GetRegion regionProvider) {
        this.strictRegions.add(regionProvider);
    }

    protected void floating_(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floatingRegions.add(new FloatingRegionByRectangle(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
    }

    protected void floating(GetFloatingRegion regionProvider) {
        this.floatingRegions.add(regionProvider);
    }

    public CheckSettings clone() {
        CheckSettings clone = new CheckSettings();
        this.populateClone(clone);
        return clone;
    }

    public Boolean isStitchContent() {
        return this.stitchContent;
    }

    public ICheckSettings ignore(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.ignore_(region);
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    public ICheckSettings ignore(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    public ICheckSettings layout(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.layout_(region);
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    public ICheckSettings layout(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    public ICheckSettings strict(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.strict_(region);
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    public ICheckSettings strict(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    public ICheckSettings content(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.content_(region);
        for (Region r : regions) {
            clone.content_(r);
        }
        return clone;
    }

    public ICheckSettings content(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.content_(r);
        }
        return clone;
    }

    public ICheckSettings fully() {
        CheckSettings clone = this.clone();
        clone.stitchContent = true;
        return clone;
    }

    public ICheckSettings fully(Boolean fully) {
        CheckSettings clone = this.clone();
        clone.stitchContent = fully;
        return clone;
    }

    public ICheckSettings floating(int maxOffset, Region ... regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.floating_(r, maxOffset, maxOffset, maxOffset, maxOffset);
        }
        return clone;
    }

    public ICheckSettings floating(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        CheckSettings clone = this.clone();
        clone.floating_(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset);
        return clone;
    }

    public ICheckSettings timeout(int timeoutMilliseconds) {
        CheckSettings clone = this.clone();
        clone.timeout = timeoutMilliseconds;
        return clone;
    }

    public ICheckSettings layout() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.LAYOUT;
        return clone;
    }

    public ICheckSettings exact() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.EXACT;
        return clone;
    }

    public ICheckSettings strict() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.STRICT;
        return clone;
    }

    public ICheckSettings content() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.CONTENT;
        return clone;
    }

    public ICheckSettings matchLevel(MatchLevel matchLevel) {
        CheckSettings clone = this.clone();
        clone.matchLevel = matchLevel;
        return clone;
    }

    public ICheckSettings ignoreCaret(boolean ignoreCaret) {
        CheckSettings clone = this.clone();
        clone.ignoreCaret = ignoreCaret;
        return clone;
    }

    public ICheckSettings ignoreCaret() {
        CheckSettings clone = this.clone();
        clone.ignoreCaret = true;
        return clone;
    }

    public ICheckSettings withName(String name) {
        CheckSettings clone = this.clone();
        clone.name = name;
        return clone;
    }

    @Override
    public Boolean isSendDom() {
        return this.sendDom;
    }

    @Override
    public Boolean isIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    @Override
    public Boolean isUseDom() {
        return this.useDom != null ? this.useDom : Boolean.FALSE;
    }

    public ICheckSettings useDom(boolean useDom) {
        CheckSettings clone = this.clone();
        clone.useDom = useDom;
        return clone;
    }

    public ICheckSettings sendDom(boolean sendDom) {
        CheckSettings clone = this.clone();
        clone.sendDom = sendDom;
        return clone;
    }

    public ICheckSettings sendDom() {
        return this.sendDom(true);
    }

    public Region getTargetRegion() {
        return this.targetRegion;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public Boolean getStitchContent() {
        return this.stitchContent;
    }

    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    @Override
    public GetRegion[] getIgnoreRegions() {
        return this.ignoreRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getStrictRegions() {
        return this.strictRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getLayoutRegions() {
        return this.layoutRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getContentRegions() {
        return this.contentRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetFloatingRegion[] getFloatingRegions() {
        return this.floatingRegions.toArray(new GetFloatingRegion[0]);
    }

    @Override
    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getScriptHooks() {
        return this.scriptHooks;
    }

    public String getSizeMode() {
        return null;
    }

    public Region getRegion() {
        return this.targetRegion;
    }

    protected void updateTargetRegion(Region region) {
        this.targetRegion = region;
    }

    protected void populateClone(CheckSettings clone) {
        clone.targetRegion = this.targetRegion;
        clone.matchLevel = this.matchLevel;
        clone.stitchContent = this.stitchContent;
        clone.timeout = this.timeout;
        clone.ignoreCaret = this.ignoreCaret;
        clone.name = this.name;
        clone.ignoreRegions.addAll(this.ignoreRegions);
        clone.contentRegions.addAll(this.contentRegions);
        clone.layoutRegions.addAll(this.layoutRegions);
        clone.strictRegions.addAll(this.strictRegions);
        clone.floatingRegions.addAll(this.floatingRegions);
        clone.scriptHooks.putAll(this.scriptHooks);
        clone.enablePatterns = this.enablePatterns;
        clone.ignoreDisplacements = this.ignoreDisplacements;
        clone.accessibilityRegions = this.accessibilityRegions;
        clone.useDom = this.useDom;
    }

    public void setStitchContent(boolean stitchContent) {
        this.stitchContent = stitchContent;
    }

    @Override
    public boolean isEnablePatterns() {
        return this.enablePatterns != null ? this.enablePatterns : false;
    }

    @Override
    public VisualGridSelector getVGTargetSelector() {
        return null;
    }

    public ICheckSettings enablePatterns(boolean enablePatterns) {
        CheckSettings clone = this.clone();
        clone.enablePatterns = enablePatterns;
        return clone;
    }

    public ICheckSettings enablePatterns() {
        CheckSettings clone = this.clone();
        clone.enablePatterns = true;
        return clone;
    }

    @Override
    @Deprecated
    public ICheckSettings scriptHook(String hook) {
        return this.beforeRenderScreenshotHook(hook);
    }

    @Override
    public ICheckSettings beforeRenderScreenshotHook(String hook) {
        CheckSettings clone = this.clone();
        clone.scriptHooks.put(BEFORE_CAPTURE_SCREENSHOT, hook);
        return clone;
    }

    public ICheckSettings ignoreDisplacements(boolean ignoreDisplacements) {
        CheckSettings clone = this.clone();
        clone.ignoreDisplacements = ignoreDisplacements;
        return clone;
    }

    public ICheckSettings ignoreDisplacements() {
        return this.ignoreDisplacements(true);
    }

    protected void accessibility_(IGetAccessibilityRegion accessibilityRegionProvider) {
        this.accessibilityRegions.add(accessibilityRegionProvider);
    }

    protected void accessibility_(Region rect, AccessibilityRegionType regionType) {
        this.accessibility_((IGetAccessibilityRegion)new AccessibilityRegionByRectangle(rect, regionType));
    }

    public ICheckSettings accessibility(Region region, AccessibilityRegionType regionType) {
        CheckSettings clone = this.clone();
        clone.accessibility_(region, regionType);
        return clone;
    }

    protected void accessibility(IGetAccessibilityRegion accessibilityRegionProvider) {
        this.accessibilityRegions.add(accessibilityRegionProvider);
    }

    @Override
    public IGetAccessibilityRegion[] getAccessibilityRegions() {
        return this.accessibilityRegions.toArray(new IGetAccessibilityRegion[0]);
    }
}

