/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CutProvider;
import com.applitools.eyes.Region;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;

public class FixedCutProvider
implements CutProvider {
    private final int header;
    private final int footer;
    private final int left;
    private final int right;

    public FixedCutProvider(int header, int footer, int left, int right) {
        this.header = header;
        this.footer = footer;
        this.left = left;
        this.right = right;
    }

    @Override
    public BufferedImage cut(BufferedImage image) {
        if (this.header > 0) {
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(0, this.header, image.getWidth(), image.getHeight() - this.header));
        }
        if (this.footer > 0) {
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(0, 0, image.getWidth(), image.getHeight() - this.footer));
        }
        if (this.left > 0) {
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(this.left, 0, image.getWidth() - this.left, image.getHeight()));
        }
        if (this.right > 0) {
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(0, 0, image.getWidth() - this.right, image.getHeight()));
        }
        return image;
    }

    @Override
    public CutProvider scale(double scaleRatio) {
        int scaledHeader = (int)Math.ceil((double)this.header * scaleRatio);
        int scaledFooter = (int)Math.ceil((double)this.footer * scaleRatio);
        int scaledLeft = (int)Math.ceil((double)this.left * scaleRatio);
        int scaledRight = (int)Math.ceil((double)this.right * scaleRatio);
        return new FixedCutProvider(scaledHeader, scaledFooter, scaledLeft, scaledRight);
    }
}

