/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.images;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.capture.ScreenshotProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.IConfiguration;
import com.applitools.eyes.events.ValidationResult;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.images.EyesImagesScreenshot;
import com.applitools.eyes.images.IImagesCheckTarget;
import com.applitools.eyes.images.ImagesCheckSettings;
import com.applitools.eyes.images.OcrRegion;
import com.applitools.eyes.images.Target;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.Collections;
import org.apache.commons.lang3.tuple.Pair;

public class Eyes
extends EyesBase
implements IConfiguration {
    private String title;
    private EyesImagesScreenshot screenshot;
    private String inferred;
    private Configuration config = new Configuration();

    public Eyes() {
        super(new ClassicRunner());
    }

    public String getBaseAgentId() {
        return "eyes.images.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    protected ScreenshotProvider getScreenshotProvider() {
        return null;
    }

    public String tryCaptureDom() {
        return null;
    }

    public void open(String appName, String testName, RectangleSize dimensions) throws EyesException {
        this.config.setAppName(appName);
        this.config.setTestName(testName);
        this.config.setViewportSize(dimensions);
    }

    public void open(String appName, String testName) {
        this.config.setAppName(appName);
        this.config.setTestName(testName);
    }

    public boolean check(String name, ICheckSettings checkSettings) {
        IImagesCheckTarget imagesCheckTarget;
        IImagesCheckTarget iImagesCheckTarget = imagesCheckTarget = checkSettings instanceof IImagesCheckTarget ? (IImagesCheckTarget)checkSettings : null;
        if (imagesCheckTarget == null) {
            return false;
        }
        BufferedImage image = imagesCheckTarget.getImage();
        return this.checkImage_(RegionProvider.NULL_INSTANCE, image, name, checkSettings);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image) {
        return this.checkImage(image);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image, String tag) {
        return this.checkImage(image, tag);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image, String tag, boolean ignoreMismatch) {
        return this.checkImage(image, tag, ignoreMismatch);
    }

    public boolean checkImage(BufferedImage image) {
        return this.checkImage(image, null);
    }

    public boolean checkImage(BufferedImage image, String tag) {
        return this.checkImage(image, tag, false);
    }

    public boolean checkImage(BufferedImage image, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            return false;
        }
        ArgumentGuard.notNull((Object)image, (String)"image cannot be null!");
        return this.checkImage_(RegionProvider.NULL_INSTANCE, image, tag, (ICheckSettings)new CheckSettings(-1));
    }

    public boolean checkImage(String path) {
        return this.checkImage(path, null);
    }

    public boolean checkImage(String path, String tag) {
        return this.checkImage(path, tag, false);
    }

    public boolean checkImage(String path, String tag, boolean ignoreMismatch) {
        return this.checkImage(ImageUtils.imageFromFile((String)path), tag, ignoreMismatch);
    }

    public boolean checkImage(byte[] image) {
        return this.checkImage(image, null);
    }

    public boolean checkImage(byte[] image, String tag) {
        return this.checkImage(image, tag, false);
    }

    public boolean checkImage(byte[] image, String tag, boolean ignoreMismatch) {
        return this.checkImage(ImageUtils.imageFromBytes((byte[])image), tag, ignoreMismatch);
    }

    public boolean checkRegion(BufferedImage image, final Region region, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            return false;
        }
        ArgumentGuard.notNull((Object)image, (String)"image cannot be null!");
        ArgumentGuard.notNull((Object)region, (String)"region cannot be null!");
        return this.checkImage_(new RegionProvider(){

            public Region getRegion() {
                return region;
            }
        }, image, tag, (ICheckSettings)new CheckSettings(-1));
    }

    public void checkRegion(BufferedImage image, Region region, String tag) {
        this.checkRegion(image, region, tag, false);
    }

    public void checkRegion(BufferedImage image, Region region) {
        this.checkRegion(image, region, null, false);
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addTextTrigger(Region control, String text) {
        this.addTextTriggerBase(control, text);
    }

    public RectangleSize getViewportSize() {
        return this.config.getViewportSize();
    }

    public SessionType getSessionType() {
        return this.config.getSessionType();
    }

    public FailureReports getFailureReports() {
        return this.config.getFailureReports();
    }

    public Configuration setViewportSize(RectangleSize size) {
        ArgumentGuard.notNull((Object)size, (String)"size");
        this.config.setViewportSize(new RectangleSize(size.getWidth(), size.getHeight()));
        return this.config;
    }

    public Configuration setSessionType(SessionType sessionType) {
        this.config.setSessionType(sessionType);
        return this.config;
    }

    public Configuration setFailureReports(FailureReports failureReports) {
        this.config.setFailureReports(failureReports);
        return this.config;
    }

    protected String getInferredEnvironment() {
        return this.inferred != null ? this.inferred : "";
    }

    public void setInferredEnvironment(String inferred) {
        this.inferred = inferred;
    }

    public EyesScreenshot getScreenshot(Region targetRegion, ICheckSettingsInternal checkSettingsInternal) {
        return this.screenshot;
    }

    protected String getTitle() {
        return this.title;
    }

    private boolean checkImage_(RegionProvider regionProvider, BufferedImage image, String tag, ICheckSettings checkSettings) {
        this.logger.log(TraceLevel.Info, Collections.singleton(this.getTestId()), Stage.CHECK, Type.CALLED, new Pair[]{Pair.of((Object)"configuration", (Object)this.getConfiguration()), Pair.of((Object)"checkSettings", (Object)checkSettings)});
        if (this.config.getViewportSize() == null || this.config.getViewportSize().isEmpty()) {
            this.setViewportSize(new RectangleSize(image.getWidth(), image.getHeight()));
        }
        if (!this.isOpen) {
            this.openBase();
        }
        image = ImageUtils.normalizeImageType((BufferedImage)image);
        CutProvider cutProvider = (CutProvider)this.cutProviderHandler.get();
        if (!(cutProvider instanceof NullCutProvider)) {
            image = cutProvider.cut(image);
            this.debugScreenshotsProvider.save(image, "cut");
        }
        this.screenshot = new EyesImagesScreenshot(this.logger, image);
        this.title = tag != null ? tag : "";
        MatchResult result = this.checkWindowBase(regionProvider.getRegion((ICheckSettingsInternal)checkSettings), checkSettings.withName(tag), null);
        ValidationResult validationResult = new ValidationResult();
        validationResult.setAsExpected(result.getAsExpected());
        return result.getAsExpected();
    }

    public Configuration setAppName(String appName) {
        this.config.setAppName(appName);
        return this.config;
    }

    public Configuration setTestName(String testName) {
        return this.config.setTestName(testName);
    }

    public String getAppName() {
        return this.config.getAppName();
    }

    public String getTestName() {
        return this.getConfigurationInstance().getTestName();
    }

    public Configuration setBranchName(String branchName) {
        this.config.setBranchName(branchName);
        return this.config;
    }

    public Configuration setAgentId(String agentId) {
        return this.config;
    }

    public String getBranchName() {
        return this.config.getBranchName();
    }

    public String getAgentId() {
        return null;
    }

    public Configuration setParentBranchName(String branchName) {
        this.config.setParentBranchName(branchName);
        return this.config;
    }

    public String getParentBranchName() {
        return this.config.getParentBranchName();
    }

    public Configuration setBaselineBranchName(String branchName) {
        this.config.setBaselineBranchName(branchName);
        return this.config;
    }

    public String getBaselineBranchName() {
        return this.config.getBaselineBranchName();
    }

    public Configuration setSaveDiffs(Boolean saveDiffs) {
        this.config.setSaveDiffs(saveDiffs);
        return this.config;
    }

    public Boolean getSaveDiffs() {
        return this.config.getSaveDiffs();
    }

    public Configuration setMatchTimeout(int ms) {
        int MIN_MATCH_TIMEOUT = 500;
        if (this.getIsDisabled()) {
            return this.config;
        }
        if (ms != 0 && 500 > ms) {
            throw new IllegalArgumentException("Match timeout must be set in milliseconds, and must be > 500");
        }
        this.config.setMatchTimeout(ms);
        return this.config;
    }

    public int getMatchTimeout() {
        return this.config.getMatchTimeout();
    }

    public Configuration setSaveNewTests(boolean saveNewTests) {
        this.config.setSaveNewTests(saveNewTests);
        return this.config;
    }

    public boolean getSaveNewTests() {
        return this.config.getSaveNewTests();
    }

    public Configuration setSaveFailedTests(boolean saveFailedTests) {
        this.config.setSaveFailedTests(saveFailedTests);
        return this.config;
    }

    public boolean getSaveFailedTests() {
        return this.config.getSaveFailedTests();
    }

    public Configuration setBatch(BatchInfo batch) {
        if (this.getIsDisabled()) {
            return this.config;
        }
        this.config.setBatch(batch);
        return this.config;
    }

    public BatchInfo getBatch() {
        return this.config.getBatch();
    }

    public Configuration setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        ArgumentGuard.notNull((Object)defaultMatchSettings, (String)"defaultMatchSettings");
        this.config.setDefaultMatchSettings(defaultMatchSettings);
        return this.config;
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.config.getDefaultMatchSettings();
    }

    public Configuration setMatchLevel(MatchLevel matchLevel) {
        this.config.getDefaultMatchSettings().setMatchLevel(matchLevel);
        return this.config;
    }

    public Configuration setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.config.setIgnoreDisplacements(isIgnoreDisplacements);
        return this.config;
    }

    public Configuration setAccessibilityValidation(AccessibilitySettings accessibilityValidation) {
        return this.config.setAccessibilityValidation(accessibilityValidation);
    }

    public Configuration setUseDom(boolean useDom) {
        return this.config.setUseDom(useDom);
    }

    public Configuration setEnablePatterns(boolean enablePatterns) {
        return this.config.setEnablePatterns(enablePatterns);
    }

    public MatchLevel getMatchLevel() {
        return this.config.getDefaultMatchSettings().getMatchLevel();
    }

    public boolean getIgnoreDisplacements() {
        return this.config.getIgnoreDisplacements();
    }

    public AccessibilitySettings getAccessibilityValidation() {
        return this.config.getAccessibilityValidation();
    }

    public boolean getUseDom() {
        return this.config.getUseDom();
    }

    public boolean getEnablePatterns() {
        return this.config.getEnablePatterns();
    }

    public boolean getIgnoreCaret() {
        Boolean ignoreCaret = this.config.getDefaultMatchSettings().getIgnoreCaret();
        return ignoreCaret == null ? true : ignoreCaret;
    }

    public Configuration setIgnoreCaret(boolean value) {
        this.config.getDefaultMatchSettings().setIgnoreCaret(Boolean.valueOf(value));
        return this.config;
    }

    public int getStitchOverlap() {
        return this.config.getStitchOverlap();
    }

    public Configuration setStitchOverlap(int pixels) {
        this.config.setStitchOverlap(pixels);
        return this.config;
    }

    public Configuration setHostOS(String hostOS) {
        if (hostOS == null || hostOS.isEmpty()) {
            this.config.setHostOS(null);
        } else {
            this.config.setHostOS(hostOS.trim());
        }
        return this.config;
    }

    public String getHostOS() {
        return this.config.getHostOS();
    }

    public Configuration setHostApp(String hostApp) {
        if (hostApp == null || hostApp.isEmpty()) {
            this.config.setHostApp(null);
        } else {
            this.config.setHostApp(hostApp.trim());
        }
        return this.config;
    }

    public String getHostApp() {
        return this.config.getHostApp();
    }

    public void setBaselineName(String baselineName) {
        this.setBaselineEnvName(baselineName);
    }

    public String getBaselineName() {
        return this.getBaselineEnvName();
    }

    public Configuration setBaselineEnvName(String baselineEnvName) {
        if (baselineEnvName == null || baselineEnvName.isEmpty()) {
            this.config.setBaselineEnvName(null);
        } else {
            this.config.setBaselineEnvName(baselineEnvName.trim());
        }
        return this.config;
    }

    public Configuration setEnvironmentName(String environmentName) {
        return this.config;
    }

    public String getBaselineEnvName() {
        return this.config.getBaselineEnvName();
    }

    public String getEnvironmentName() {
        return null;
    }

    public void setEnvName(String envName) {
        if (envName == null || envName.isEmpty()) {
            this.config.setEnvironmentName(null);
        } else {
            this.config.setEnvironmentName(envName.trim());
        }
    }

    public String getEnvName() {
        return this.config.getEnvironmentName();
    }

    @Deprecated
    public void setAppEnvironment(String hostOS, String hostApp) {
        if (this.getIsDisabled()) {
            return;
        }
        this.setHostOS(hostOS);
        this.setHostApp(hostApp);
    }

    public String getApiKey() {
        return super.getApiKey();
    }

    protected Configuration getConfigurationInstance() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = new Configuration(config);
    }

    protected void getAppOutputForOcr(BaseOcrRegion ocrRegion) {
        BufferedImage image = ((OcrRegion)ocrRegion).getImage();
        ImagesCheckSettings imagesCheckSettings = (ImagesCheckSettings)Target.image(image);
        this.checkImage_(RegionProvider.NULL_INSTANCE, image, "", imagesCheckSettings.ocrRegion(ocrRegion));
    }
}

