/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.Response;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public class ResponseImpl
extends Response {
    javax.ws.rs.core.Response response;

    ResponseImpl(javax.ws.rs.core.Response response, Logger logger) {
        super(logger);
        this.response = response;
        this.readEntity();
        this.logIfError();
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    public String getStatusPhrase() {
        return this.response.getStatusInfo().getReasonPhrase();
    }

    public String getHeader(String name, boolean ignoreCase) {
        ArgumentGuard.notNullOrEmpty((String)name, (String)"name");
        MultivaluedMap headers = this.response.getStringHeaders();
        if (!ignoreCase) {
            return (String)headers.getFirst((Object)name);
        }
        for (String key : headers.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            return (String)headers.getFirst((Object)key);
        }
        return null;
    }

    protected Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : this.response.getStringHeaders().keySet()) {
            headers.put(key, this.getHeader(key, false));
        }
        return headers;
    }

    public void readEntity() {
        this.body = (byte[])this.response.readEntity(byte[].class);
    }

    public void close() {
        this.response.close();
    }
}

