/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.RequestPollingCallback;
import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.ConnectivityTarget;
import com.applitools.connectivity.api.HttpClient;
import com.applitools.connectivity.api.HttpClientImpl;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.brotli.dec.BrotliInputStream;

public class RestClient {
    private static final String AGENT_ID_CUSTOM_HEADER = "x-applitools-eyes-client";
    protected Logger logger;
    protected HttpClient restClient;
    protected URI serverUrl;
    protected String agentId;
    protected ObjectMapper jsonMapper;

    public RestClient(Logger logger, URI serverUrl, int timeout) {
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        this.logger = logger;
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.serverUrl = serverUrl;
        this.restClient = new HttpClientImpl(logger, timeout, null);
    }

    public void setLogger(Logger logger) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        if (this.restClient != null) {
            this.restClient.setLogger(logger);
        }
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        int timeout = this.restClient.getTimeout();
        this.restClient.close();
        this.restClient = new HttpClientImpl(this.logger, timeout, proxySettings);
    }

    public AbstractProxySettings getProxy() {
        return this.restClient.getProxySettings();
    }

    public void setTimeout(int timeout) {
        ArgumentGuard.greaterThanOrEqualToZero((long)timeout, (String)"timeout");
        AbstractProxySettings proxySettings = this.restClient.getProxySettings();
        this.restClient.close();
        this.restClient = new HttpClientImpl(this.logger, timeout, proxySettings);
    }

    public int getTimeout() {
        return this.restClient.getTimeout();
    }

    protected void setServerUrlBase(URI serverUrl) {
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
    }

    protected URI getServerUrlBase() {
        return this.serverUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    protected void initClient() {
        if (this.restClient.isClosed()) {
            this.restClient = new HttpClientImpl(this.logger, this.getTimeout(), this.getProxy());
        }
    }

    public void sendAsyncRequest(AsyncRequestCallback callback, String url, String method, String ... accept) {
        this.sendAsyncRequest(callback, url, method, new HashMap<String, String>(), accept);
    }

    public void sendAsyncRequest(AsyncRequestCallback callback, final String url, String method, final Map<String, String> queryParams, final String ... accept) {
        AsyncRequest request = this.makeEyesRequest(new HttpRequestBuilder(){

            @Override
            public AsyncRequest build() {
                ConnectivityTarget target = RestClient.this.restClient.target(url);
                for (Map.Entry pair : queryParams.entrySet()) {
                    target.queryParam((String)pair.getKey(), (String)pair.getValue());
                }
                return target.asyncRequest(accept);
            }
        });
        this.sendAsyncRequest(request, method, callback);
    }

    public void sendAsyncRequest(AsyncRequest request, String method, AsyncRequestCallback callback) {
        this.sendAsyncRequest(request, method, callback, null, null);
    }

    public void sendAsyncRequest(AsyncRequest request, String method, AsyncRequestCallback callback, Object data, String contentType) {
        String currentTime = GeneralUtils.toRfc1123((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        request.header("Eyes-Date", currentTime).method(method, callback, data, contentType);
    }

    protected AsyncRequest makeEyesRequest(HttpRequestBuilder builder) {
        AsyncRequest request = builder.build();
        if (this.agentId == null) {
            return request;
        }
        return request.header(AGENT_ID_CUSTOM_HEADER, this.agentId);
    }

    public Response sendHttpRequest(String url, String method, String ... accept) {
        final SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("sendHttpRequest to %s", url));
        this.sendAsyncRequest(new AsyncRequestCallback(){

            public void onComplete(Response response) {
                listener.onComplete((Object)response);
            }

            public void onFail(Throwable throwable) {
                listener.onFail();
            }
        }, url, method, new HashMap<String, String>(), accept);
        Response response = (Response)listener.get();
        if (response == null) {
            throw new EyesException("Failed getting response from the server");
        }
        return response;
    }

    protected void sendLongRequest(AsyncRequest request, String method, final AsyncRequestCallback callback, String data, String mediaType) throws EyesException {
        String currentTime = GeneralUtils.toRfc1123((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        request = request.header("Eyes-Expect", "202+location").header("Eyes-Expect-Version", "2").header("Eyes-Date", currentTime);
        AsyncRequestCallback requestFinishedCallback = new AsyncRequestCallback(){

            public void onComplete(Response response) {
                String statusUrl = response.getHeader("Location", true);
                int status = response.getStatusCode();
                if (statusUrl == null || status != 202) {
                    callback.onComplete(response);
                    return;
                }
                response.close();
                RequestPollingCallback pollingCallback = new RequestPollingCallback(RestClient.this, statusUrl, callback);
                RestClient.this.sendAsyncRequest((AsyncRequestCallback)pollingCallback, statusUrl, "GET", new String[0]);
            }

            public void onFail(Throwable throwable) {
                callback.onFail(throwable);
            }
        };
        this.sendAsyncRequest(request, method, requestFinishedCallback, (Object)data, mediaType);
    }

    protected String getReadResponseError(String errMsg, int statusCode, String statusPhrase, String responseBody) {
        ArgumentGuard.notNull((Object)statusPhrase, (String)"statusPhrase");
        if (errMsg == null) {
            errMsg = "";
        }
        if (responseBody == null) {
            responseBody = "";
        }
        return errMsg + " [" + statusCode + " " + statusPhrase + "] " + responseBody;
    }

    protected <T> T parseResponseWithJsonData(Response response, List<Integer> validHttpStatusCodes, TypeReference<T> resultType) throws EyesException {
        Object resultObject;
        ArgumentGuard.notNull((Object)response, (String)"response");
        ArgumentGuard.notNull(validHttpStatusCodes, (String)"validHttpStatusCodes");
        ArgumentGuard.notNull(resultType, (String)"resultType");
        int statusCode = response.getStatusCode();
        String statusPhrase = response.getStatusPhrase();
        String data = response.getBodyString();
        response.close();
        if (!validHttpStatusCodes.contains(statusCode)) {
            String errorMessage = this.getReadResponseError("Invalid status code", statusCode, statusPhrase, data);
            if (statusCode == 401 || statusCode == 403) {
                errorMessage = errorMessage + "\nThis is most likely due to an invalid API key.";
            }
            throw new EyesException(errorMessage);
        }
        try {
            resultObject = this.jsonMapper.readValue(data, resultType);
        }
        catch (IOException e) {
            String errorMessage = this.getReadResponseError("Failed deserialize response body", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage, (Throwable)e);
        }
        return (T)resultObject;
    }

    protected byte[] downloadFile(Response response) {
        byte[] responseBody = response.getBody();
        String contentEncoding = response.getHeader("Content-Encoding", false);
        if (!"br".equalsIgnoreCase(contentEncoding)) {
            return responseBody;
        }
        try {
            return IOUtils.toByteArray((InputStream)new BrotliInputStream((InputStream)new ByteArrayInputStream(responseBody)));
        }
        catch (IOException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            return new byte[0];
        }
    }

    protected static interface HttpRequestBuilder {
        public AsyncRequest build();
    }

    protected static interface HttpMethodCall {
        public Response call();
    }
}

