/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.ProxySettings;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class RestClient {
    private ProxySettings proxySettings;
    private int timeout;
    protected final Logger logger;
    protected Client restClient;
    protected URI serverUrl;
    protected WebTarget endPoint;
    protected ObjectMapper jsonMapper;

    private static Client buildRestClient(int timeout, ProxySettings proxySettings) {
        ClientConfig cc = new ClientConfig();
        cc.property("jersey.config.client.connectTimeout", (Object)timeout);
        cc.property("jersey.config.client.readTimeout", (Object)timeout);
        if (proxySettings != null) {
            cc = cc.property("jersey.config.client.proxy.uri", (Object)proxySettings.getUri());
            if (proxySettings.getUsername() != null) {
                cc = cc.property("jersey.config.client.proxy.username", (Object)proxySettings.getUsername());
            }
            if (proxySettings.getPassword() != null) {
                cc = cc.property("jersey.config.client.proxy.password", (Object)proxySettings.getPassword());
            }
        }
        cc.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        cc.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        return ClientBuilder.newBuilder().withConfig((Configuration)cc).build();
    }

    public RestClient(Logger logger, URI serverUrl, int timeout) {
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        ArgumentGuard.greaterThanOrEqualToZero((long)timeout, (String)"timeout");
        this.logger = logger;
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.timeout = timeout;
        this.serverUrl = serverUrl;
        this.restClient = RestClient.buildRestClient(timeout, this.proxySettings);
        this.endPoint = this.restClient.target(serverUrl);
    }

    public RestClient(Logger logger, URI serverUrl) {
        this(logger, serverUrl, 300000);
    }

    public void setProxyBase(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
        this.restClient = RestClient.buildRestClient(this.timeout, proxySettings);
        this.endPoint = this.restClient.target(this.serverUrl);
    }

    public ProxySettings getProxyBase() {
        return this.proxySettings;
    }

    public void setTimeout(int timeout) {
        ArgumentGuard.greaterThanOrEqualToZero((long)timeout, (String)"timeout");
        this.timeout = timeout;
        this.restClient = RestClient.buildRestClient(timeout, this.proxySettings);
        this.endPoint = this.restClient.target(this.serverUrl);
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected void setServerUrlBase(URI serverUrl) {
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
        this.endPoint = this.restClient.target(serverUrl);
    }

    protected URI getServerUrlBase() {
        return this.serverUrl;
    }

    protected Response sendLongRequest(HttpMethodCall method, String name) throws EyesException {
        int maxDelay = 10000;
        int delay = 2000;
        Response response;
        while ((response = method.call()).getStatus() == 202) {
            response.close();
            this.logger.verbose(String.format("%s: Still running... Retrying in %d ms", name, delay));
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new EyesException("Long request interrupted!", (Throwable)e);
            }
            delay = Math.min(maxDelay, (int)Math.floor((double)delay * 1.5));
        }
        return response;
    }

    protected String getReadResponseError(String errMsg, int statusCode, String statusPhrase, String responseBody) {
        ArgumentGuard.notNull((Object)statusPhrase, (String)"statusPhrase");
        if (errMsg == null) {
            errMsg = "";
        }
        if (responseBody == null) {
            responseBody = "";
        }
        return errMsg + " [" + statusCode + " " + statusPhrase + "] " + responseBody;
    }

    protected <T> T parseResponseWithJsonData(Response response, List<Integer> validHttpStatusCodes, Class<T> resultType) throws EyesException {
        Object resultObject;
        ArgumentGuard.notNull((Object)response, (String)"response");
        ArgumentGuard.notNull(validHttpStatusCodes, (String)"validHttpStatusCodes");
        ArgumentGuard.notNull(resultType, (String)"resultType");
        int statusCode = response.getStatus();
        String statusPhrase = response.getStatusInfo().getReasonPhrase();
        String data = (String)response.readEntity(String.class);
        response.close();
        if (!validHttpStatusCodes.contains(statusCode)) {
            String errorMessage = this.getReadResponseError("Invalid status code", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage);
        }
        try {
            resultObject = this.jsonMapper.readValue(data, resultType);
        }
        catch (IOException e) {
            String errorMessage = this.getReadResponseError("Failed to de-serialize response body", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage, (Throwable)e);
        }
        return (T)resultObject;
    }

    protected static interface HttpMethodCall {
        public Response call();
    }
}

