/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.IResourceUploadListener;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IDownloadListener;
import com.applitools.eyes.IPutFuture;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RestClient;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.Utils;
import com.applitools.eyes.visualgrid.PutFuture;
import com.applitools.eyes.visualgrid.ResourceFuture;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatus;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.eyes.visualgrid.services.IResourceFuture;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.brotli.dec.BrotliInputStream;
import org.glassfish.jersey.message.GZipEncoder;

public class ServerConnector
extends RestClient
implements IServerConnector {
    private String apiKey = null;
    private RenderingInfo renderingInfo;

    public ServerConnector(Logger logger, URI serverUrl) {
        super(logger, serverUrl, 300000);
        this.endPoint = this.endPoint.path("/api/sessions/running");
    }

    public ServerConnector(Logger logger) {
        this(logger, GeneralUtils.getDefaultServerUrl());
    }

    public ServerConnector(URI serverUrl) {
        this(null, serverUrl);
    }

    public ServerConnector() {
        this((Logger)null);
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        String apiKey = this.apiKey != null ? this.apiKey : GeneralUtils.getEnvString((String)"APPLITOOLS_API_KEY");
        apiKey = apiKey == null ? GeneralUtils.getEnvString((String)"bamboo_APPLITOOLS_API_KEY") : apiKey;
        return apiKey;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        this.setProxyBase(proxySettings);
        this.endPoint = this.endPoint.path("/api/sessions/running");
    }

    public AbstractProxySettings getProxy() {
        return this.getProxyBase();
    }

    public void setServerUrl(URI serverUrl) {
        this.setServerUrlBase(serverUrl);
        this.endPoint = this.endPoint.path("/api/sessions/running");
    }

    public URI getServerUrl() {
        return this.getServerUrlBase();
    }

    public RunningSession startSession(SessionStartInfo sessionStartInfo) throws EyesException {
        Response response;
        String postData;
        ArgumentGuard.notNull((Object)sessionStartInfo, (String)"sessionStartInfo");
        this.logger.verbose("Using Jersey2 for REST API calls.");
        this.configureRestClient();
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", (Throwable)e);
        }
        try {
            Invocation.Builder request = this.endPoint.queryParam("apiKey", new Object[]{this.getApiKey()}).request(new String[]{"application/json"});
            response = this.sendWithRetry("POST", request, Entity.json((Object)postData), null);
        }
        catch (RuntimeException e) {
            this.logger.log("Server request failed: " + e.getMessage());
            throw e;
        }
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        validStatusCodes.add(Response.Status.CREATED.getStatusCode());
        RunningSession runningSession = this.parseResponseWithJsonData(response, validStatusCodes, RunningSession.class);
        int statusCode = response.getStatus();
        boolean isNewSession = statusCode == Response.Status.CREATED.getStatusCode();
        runningSession.setIsNewSession(isNewSession);
        return runningSession;
    }

    public TestResults stopSession(RunningSession runningSession, final boolean isAborted, final boolean save) throws EyesException {
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        final String sessionId = runningSession.getId();
        RestClient.HttpMethodCall delete = new RestClient.HttpMethodCall(){

            @Override
            public Response call() {
                String currentTime = GeneralUtils.toRfc1123((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                Invocation.Builder invocationBuilder = ServerConnector.this.endPoint.path(sessionId).queryParam("apiKey", new Object[]{ServerConnector.this.getApiKey()}).queryParam("aborted", new Object[]{String.valueOf(isAborted)}).queryParam("updateBaseline", new Object[]{String.valueOf(save)}).request(new String[]{"application/json"}).header("Eyes-Expect", (Object)"202-accepted").header("Eyes-Date", (Object)currentTime);
                return invocationBuilder.delete();
            }
        };
        Response response = this.sendLongRequest(delete, "stopSession");
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        TestResults result = this.parseResponseWithJsonData(response, validStatusCodes, TestResults.class);
        return result;
    }

    public void deleteSession(TestResults testResults) {
        ArgumentGuard.notNull((Object)testResults, (String)"testResults");
        this.configureRestClient();
        Invocation.Builder invocationBuilder = this.restClient.target(this.serverUrl).path("/api/sessions/batches/").path(testResults.getBatchId()).path("/").path(testResults.getId()).queryParam("apiKey", new Object[]{this.getApiKey()}).queryParam("AccessToken", new Object[]{testResults.getSecretToken()}).request(new String[]{"application/json"});
        Response response = invocationBuilder.delete();
    }

    public MatchResult matchWindow(RunningSession runningSession, MatchWindowData matchData) throws EyesException {
        byte[] requestData;
        byte[] jsonBytes;
        String jsonData;
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.notNull((Object)matchData, (String)"model");
        WebTarget runningSessionsEndpoint = this.endPoint.path(runningSession.getId());
        try {
            jsonData = this.jsonMapper.writeValueAsString((Object)matchData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize model for matchWindow!", (Throwable)e);
        }
        ByteArrayOutputStream jsonToBytesConverter = new ByteArrayOutputStream();
        try {
            jsonToBytesConverter.write(jsonData.getBytes("UTF-8"));
            jsonToBytesConverter.flush();
            jsonBytes = jsonToBytesConverter.toByteArray();
        }
        catch (IOException e) {
            throw new EyesException("Failed create binary model from JSON!", (Throwable)e);
        }
        byte[] screenshot = Base64.decodeBase64((String)matchData.getAppOutput().getScreenshot64());
        ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
        DataOutputStream requestDos = new DataOutputStream(requestOutputStream);
        try {
            requestDos.writeInt(jsonBytes.length);
            requestDos.flush();
            requestOutputStream.write(jsonBytes);
            if (screenshot != null) {
                requestOutputStream.write(screenshot);
            }
            requestOutputStream.flush();
            requestData = requestOutputStream.toByteArray();
            requestDos.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed send check window request!", (Throwable)e);
        }
        Invocation.Builder request = runningSessionsEndpoint.queryParam("apiKey", new Object[]{this.getApiKey()}).request(new String[]{"application/json"});
        Response response = this.sendWithRetry("POST", request, Entity.entity((Object)requestData, (String)"application/octet-stream"), null);
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        MatchResult result = this.parseResponseWithJsonData(response, validStatusCodes, MatchResult.class);
        return result;
    }

    public void downloadString(final URL uri, final boolean isSecondRetry, final IDownloadListener<String> listener) {
        WebTarget target = this.restClient.target(uri.toString());
        Invocation.Builder request = target.request(new String[]{"*/*"});
        this.logger.verbose("Firing async GET");
        request.async().get((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                try {
                    byte[] resource = ServerConnector.this.downloadFile(response);
                    listener.onDownloadComplete((Object)new String(resource), null);
                    ServerConnector.this.logger.verbose("response finished");
                }
                catch (Throwable e) {
                    ServerConnector.this.logger.verbose(e.getMessage());
                }
                finally {
                    response.close();
                }
            }

            public void failed(Throwable throwable) {
                if (!isSecondRetry) {
                    ServerConnector.this.logger.verbose("Async GET failed - entering retry");
                    ServerConnector.this.downloadString(uri, true, (IDownloadListener<String>)listener);
                } else {
                    listener.onDownloadFailed();
                }
            }
        });
    }

    public IResourceFuture downloadResource(final URL url, String userAgent) {
        WebTarget target = this.restClient.target(url.toString());
        Invocation.Builder request = target.request(new String[]{"*/*"});
        request.header("User-Agent", (Object)userAgent);
        ResourceFuture newFuture = new ResourceFuture(url.toString(), this.logger, (IServerConnector)this, userAgent);
        Future responseFuture = request.async().get((InvocationCallback)new InvocationCallback<Response>((IResourceFuture)newFuture){
            final /* synthetic */ IResourceFuture val$newFuture;
            {
                this.val$newFuture = iResourceFuture;
            }

            public void completed(Response response) {
                ServerConnector.this.logger.verbose("GET callback  success");
                int status = response.getStatus();
                List contentLengthHeaders = (List)response.getStringHeaders().get((Object)"Content-length");
                int contentLength = 0;
                if (contentLengthHeaders != null) {
                    contentLength = Integer.parseInt((String)contentLengthHeaders.get(0));
                    ServerConnector.this.logger.verbose("Content Length: " + contentLength);
                }
                ServerConnector.this.logger.verbose("downloading url - : " + url);
                if (status == 404) {
                    ServerConnector.this.logger.verbose("Status 404 on url - " + url);
                }
                if (status == 200 || status == 201) {
                    ServerConnector.this.logger.verbose("response: " + response);
                    byte[] content = ServerConnector.this.downloadFile(response);
                    String contentType = Utils.getResponseContentType(response);
                    String contentEncoding = Utils.getResponseContentEncoding(response);
                    if (contentEncoding != null && contentEncoding.contains("gzip")) {
                        try {
                            content = GeneralUtils.getUnGzipByteArrayOutputStream((byte[])content);
                        }
                        catch (IOException e) {
                            GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Throwable)e);
                        }
                    }
                    RGridResource rgResource = new RGridResource(url.toString(), contentType, content, ServerConnector.this.logger, "ResourceFuture");
                    this.val$newFuture.setResource(rgResource);
                }
                response.close();
                ServerConnector.this.logger.verbose("Response closed");
            }

            public void failed(Throwable throwable) {
                ServerConnector.this.logger.verbose("PUT callback failed");
            }
        });
        newFuture.setResponseFuture(responseFuture);
        return newFuture;
    }

    public String postDomSnapshot(String domJson) {
        this.restClient.register(GZipEncoder.class);
        WebTarget target = this.restClient.target(this.serverUrl).path("api/sessions/running/data").queryParam("apiKey", new Object[]{this.getApiKey()});
        Invocation.Builder request = target.request(new String[]{"application/json"});
        byte[] resultStream = GeneralUtils.getGzipByteArrayOutputStream((String)domJson);
        Response response = this.sendWithRetry("POST", request, Entity.entity((Object)resultStream, (String)"application/octet-stream"), null);
        String entity = response.getHeaderString("Location");
        return entity;
    }

    private Response sendWithRetry(String method, Invocation.Builder request, Entity entity, AtomicInteger retiresCounter) {
        if (retiresCounter == null) {
            retiresCounter = new AtomicInteger(0);
        }
        Response response = null;
        try {
            switch (method) {
                case "POST": {
                    response = request.post(entity);
                    break;
                }
                case "PUT": {
                    response = request.put(entity);
                }
            }
            return response;
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            try {
                Thread.sleep(3L);
            }
            catch (InterruptedException e1) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e1);
            }
            if (retiresCounter.incrementAndGet() < 20) {
                return this.sendWithRetry(method, request, entity, retiresCounter);
            }
            throw e;
        }
    }

    public RenderingInfo getRenderInfo() {
        String apiKey = this.getApiKey();
        WebTarget target = this.restClient.target(this.serverUrl).path("api/sessions/renderinfo").queryParam("apiKey", new Object[]{apiKey});
        Invocation.Builder request = target.request(new String[]{"application/json"});
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        Response response = request.get();
        this.renderingInfo = this.parseResponseWithJsonData(response, validStatusCodes, RenderingInfo.class);
        return this.renderingInfo;
    }

    public List<RunningRender> render(RenderRequest ... renderRequests) {
        ArgumentGuard.notNull((Object)renderRequests, (String)"renderRequests");
        this.logger.verbose("called with " + Arrays.toString(renderRequests));
        WebTarget target = this.restClient.target(this.renderingInfo.getServiceUrl()).path("/render");
        if (renderRequests.length > 1) {
            target.matrixParam("render-id", new Object[]{renderRequests});
        } else {
            target.queryParam("render-id", new Object[]{renderRequests});
        }
        Invocation.Builder request = target.request(new String[]{"application/json"});
        request.header("X-Auth-Token", (Object)this.renderingInfo.getAccessToken());
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        validStatusCodes.add(Response.Status.NOT_FOUND.getStatusCode());
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString((Object)renderRequests);
            Response response = request.post(Entity.json((Object)json));
            if (validStatusCodes.contains(response.getStatus())) {
                RunningRender[] runningRenders = this.parseResponseWithJsonData(response, validStatusCodes, RunningRender[].class);
                return Arrays.asList(runningRenders);
            }
            throw new EyesException("Jersey2 ServerConnector.render - unexpected status (" + response.getStatus() + "), msg (" + (String)response.readEntity(String.class) + ")");
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            return null;
        }
    }

    public boolean renderCheckResource(RunningRender runningRender, RGridResource resource) {
        ArgumentGuard.notNull((Object)runningRender, (String)"runningRender");
        ArgumentGuard.notNull((Object)resource, (String)"resource");
        this.logger.verbose("called with resource#" + resource.getSha256() + " for render: " + runningRender.getRenderId());
        WebTarget target = this.restClient.target(this.renderingInfo.getServiceUrl()).path("/resources/sha256/" + resource.getSha256()).queryParam("render-id", new Object[]{runningRender.getRenderId()});
        Invocation.Builder request = target.request(new String[]{"application/json"});
        request.header("X-Auth-Token", (Object)this.renderingInfo.getAccessToken());
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        validStatusCodes.add(Response.Status.NOT_FOUND.getStatusCode());
        Response response = request.head();
        if (validStatusCodes.contains(response.getStatus())) {
            this.logger.verbose("request succeeded");
            return response.getStatus() == Response.Status.OK.getStatusCode();
        }
        throw new EyesException("Jersey2 ServerConnector.renderCheckResource - unexpected status (" + response.getStatus() + ")");
    }

    public IPutFuture renderPutResource(RunningRender runningRender, RGridResource resource, String userAgent, IResourceUploadListener listener) {
        ArgumentGuard.notNull((Object)runningRender, (String)"runningRender");
        ArgumentGuard.notNull((Object)resource, (String)"resource");
        byte[] content = resource.getContent();
        ArgumentGuard.notNull((Object)content, (String)"resource.getContent()");
        String hash = resource.getSha256();
        String renderId = runningRender.getRenderId();
        this.logger.verbose("resource hash:" + hash + " ; url: " + resource.getUrl() + " ; render id: " + renderId);
        WebTarget target = this.restClient.target(this.renderingInfo.getServiceUrl()).path("/resources/sha256/" + hash).queryParam("render-id", new Object[]{renderId});
        String contentType = resource.getContentType();
        Invocation.Builder request = target.request(new String[]{contentType});
        request.header("X-Auth-Token", (Object)this.renderingInfo.getAccessToken());
        request.header("User-Agent", (Object)userAgent);
        Entity entity = null;
        entity = contentType != null && !"None".equalsIgnoreCase(contentType) ? Entity.entity((Object)content, (String)contentType) : Entity.entity((Object)content, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Future future = request.async().put(entity, (InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                ServerConnector.this.logger.verbose("PUT callback  success");
                response.close();
                ServerConnector.this.logger.verbose("Response closed");
            }

            public void failed(Throwable throwable) {
                ServerConnector.this.logger.verbose("PUT callback failed");
            }
        });
        this.logger.verbose("future created.");
        PutFuture putFuture = new PutFuture(future, resource, runningRender, (IServerConnector)this, this.logger, userAgent);
        return putFuture;
    }

    public RenderStatusResults renderStatus(RunningRender runningRender) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RenderStatusResults> renderStatusById(String ... renderIds) {
        try (Response response = null;){
            ArgumentGuard.notNull((Object)renderIds, (String)"renderIds");
            this.logger.verbose("called for render: " + Arrays.toString(renderIds));
            WebTarget target = this.restClient.target(this.renderingInfo.getServiceUrl()).path("/render-status");
            Invocation.Builder request = target.request(new String[]{"text/plain"});
            request.header("X-Auth-Token", (Object)this.renderingInfo.getAccessToken());
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(Response.Status.OK.getStatusCode());
            validStatusCodes.add(Response.Status.NOT_FOUND.getStatusCode());
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            try {
                String json = objectMapper.writeValueAsString((Object)renderIds);
                Entity entity = Entity.entity((Object)json, (String)"application/json");
                response = request.post(entity);
                if (validStatusCodes.contains(response.getStatus())) {
                    this.logger.verbose("request succeeded");
                    RenderStatusResults[] renderStatusResults = this.parseResponseWithJsonData(response, validStatusCodes, RenderStatusResults[].class);
                    for (int i = 0; i < renderStatusResults.length; ++i) {
                        RenderStatusResults renderStatusResult = renderStatusResults[i];
                        if (renderStatusResult == null || renderStatusResult.getStatus() != RenderStatus.ERROR) continue;
                        this.logger.verbose("error on render id - " + renderStatusResult);
                    }
                    List<RenderStatusResults> list = Arrays.asList(renderStatusResults);
                    return list;
                }
            }
            catch (JsonProcessingException e) {
                this.logger.log("exception in render status");
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
            List<RenderStatusResults> list = null;
            return list;
        }
        return null;
    }

    public IResourceFuture createResourceFuture(RGridResource gridResource, String userAgent) {
        return new ResourceFuture(gridResource, this.logger, (IServerConnector)this, userAgent);
    }

    public void setRenderingInfo(RenderingInfo renderInfo) {
        this.renderingInfo = renderInfo;
    }

    public void closeBatch(String batchId) {
        boolean dontCloseBatchesStr = GeneralUtils.getDontCloseBatches();
        if (dontCloseBatchesStr) {
            this.logger.log("APPLITOOLS_DONT_CLOSE_BATCHES environment variable set to true. Skipping batch close.");
            return;
        }
        ArgumentGuard.notNull((Object)batchId, (String)"batchId");
        this.logger.verbose("called with " + batchId);
        String url = String.format("api/sessions/batches/%s/close/bypointerid", batchId);
        WebTarget target = this.restClient.target(this.serverUrl).path(url).queryParam("apiKey", new Object[]{this.getApiKey()});
        Response delete = target.request().delete();
        this.logger.verbose("delete batch is done with " + delete.getStatus() + " status");
    }

    public void closeConnector() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    private byte[] downloadFile(Response response) {
        InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
        Object contentEncoding = response.getHeaders().getFirst((Object)"Content-Encoding");
        byte[] bytes = new byte[]{};
        try {
            if ("br".equalsIgnoreCase((String)contentEncoding)) {
                inputStream = new BrotliInputStream(inputStream);
            }
            bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        return bytes;
    }

    private void configureRestClient() {
        this.restClient = ServerConnector.buildRestClient(this.getTimeout(), this.getProxy());
        this.endPoint = this.restClient.target(this.serverUrl);
        this.endPoint = this.endPoint.path("/api/sessions/running");
    }
}

