package com.applitools.connectivity.api;

import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import com.sun.jersey.api.client.ClientResponse;

import javax.ws.rs.core.MultivaluedMap;
import java.util.HashMap;
import java.util.Map;

public class ResponseImpl extends Response {

    ClientResponse response;

    ResponseImpl(ClientResponse response, Logger logger) {
        super(logger);
        this.response = response;
        readEntity();
        logIfError();
    }

    @Override
    public int getStatusCode() {
        return response.getStatus();
    }

    @Override
    public String getStatusPhrase() {
        return ClientResponse.Status.fromStatusCode(response.getStatus()).getReasonPhrase();
    }

    @Override
    public String getHeader(String name, boolean ignoreCase) {
        ArgumentGuard.notNullOrEmpty(name, "name");
        MultivaluedMap<String, String> headers = response.getHeaders();
        if (!ignoreCase) {
            return headers.getFirst(name);
        }

        for (String key : headers.keySet()) {
            if (name.equalsIgnoreCase(key)) {
                return headers.getFirst(key);
            }
        }

        return null;
    }

    @Override
    protected Map<String, String> getHeaders() {
        Map<String, String> headers = new HashMap<>();
        for (String key : response.getHeaders().keySet()) {
            headers.put(key, getHeader(key, false));
        }

        return headers;
    }

    @Override
    public void readEntity() {
        body = response.getEntity(byte[].class);
    }

    @Override
    public void close() {
        response.close();
    }
}
