/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import java.util.Arrays;

public class ArgumentGuard {
    private ArgumentGuard() {
    }

    public static void notNull(Object param, String paramName) throws IllegalArgumentException {
        if (null == param) {
            throw new IllegalArgumentException(paramName + " is null");
        }
    }

    public static <T> void notContainsNull(Iterable<T> param, String paramName) throws IllegalArgumentException {
        ArgumentGuard.notNull(param, paramName);
        for (T element : param) {
            if (element != null) continue;
            throw new IllegalArgumentException(paramName + " has null elements");
        }
    }

    public static <T> void notContainsNull(T[] param, String paramName) throws IllegalArgumentException {
        ArgumentGuard.notNull(param, paramName);
        ArgumentGuard.notContainsNull(Arrays.asList(param), paramName);
    }

    public static void notEqual(Object param, Object value, String paramName) {
        if (param == value || param != null && param.equals(value)) {
            throw new IllegalArgumentException(paramName + " == " + value);
        }
    }

    public static void notNullOrEmpty(String param, String paramName) throws IllegalArgumentException {
        ArgumentGuard.notNull(param, paramName);
        if (param.length() == 0) {
            throw new IllegalArgumentException(paramName + " is empty");
        }
    }

    public static void isNull(Object param, String paramName) throws IllegalArgumentException {
        if (null != param) {
            throw new IllegalArgumentException(paramName + " is not null");
        }
    }

    public static void greaterThanOrEqualToZero(long param, String paramName) throws IllegalArgumentException {
        if (0L > param) {
            throw new IllegalArgumentException(paramName + " < 0");
        }
    }

    public static void greaterThanZero(long param, String paramName) throws IllegalArgumentException {
        if (0L >= param) {
            throw new IllegalArgumentException(paramName + " < 1");
        }
    }

    public static void greaterThanZero(double param, String paramName) throws IllegalArgumentException {
        if (0.0 >= param) {
            throw new IllegalArgumentException(paramName + " < 1");
        }
    }

    public static void notZero(long param, String paramName) throws IllegalArgumentException {
        if (0L == param) {
            throw new IllegalArgumentException(paramName + " == 0");
        }
    }

    public static void isValidState(boolean isValid, String errMsg) throws IllegalStateException {
        if (!isValid) {
            throw new IllegalStateException(errMsg);
        }
    }

    public static void notOfType(Object param, Class paramExpectedClass, String paramName) throws IllegalArgumentException {
        if (!paramExpectedClass.isAssignableFrom(param.getClass())) {
            throw new IllegalArgumentException(paramName + " is must be a " + paramExpectedClass);
        }
    }
}

