/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.Response;
import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.utils.GeneralUtils;
import java.util.UUID;

public abstract class Request {
    public static String CONTENT_LENGTH_HEADER = "Content-Length";
    public static String CONTENT_TYPE_HEADER = "Content-Type";
    private static final int REQUEST_TIMEOUT = 60000;
    private static final int SLEEP_DURATION = 5000;
    private int timePassed = 0;
    protected Logger logger;
    protected final String requestId;

    public Request(Logger logger) {
        this.logger = logger;
        this.requestId = UUID.randomUUID().toString();
    }

    public abstract Request header(String var1, String var2);

    protected abstract Response methodInner(String var1, Object var2, String var3);

    public Response method(String method, Object data, String contentType) {
        this.header("x-applitools-request-id", this.requestId);
        try {
            Response response = this.methodInner(method, data, contentType);
            response.setRequestId(this.requestId);
            return response;
        }
        catch (Throwable t) {
            if (this.timePassed >= 60000) {
                throw t;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.timePassed += 5000;
            GeneralUtils.logExceptionStackTrace(this.logger, Stage.GENERAL, t, new String[0]);
            Response response = this.method(method, data, contentType);
            response.setRequestId(this.requestId);
            return response;
        }
    }
}

