/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.LinkedList;

@JsonIgnoreProperties(value={"location", "empty", "middleOffset", "size", "subRegions"})
public class Region {
    private int left;
    private int top;
    private int width;
    private int height;
    public static final Region EMPTY = new Region(0, 0, 0, 0);

    protected void makeEmpty() {
        this.left = EMPTY.getLeft();
        this.top = EMPTY.getTop();
        this.width = EMPTY.getWidth();
        this.height = EMPTY.getHeight();
    }

    public Region(int left, int top, int width, int height) {
        ArgumentGuard.greaterThanOrEqualToZero(width, "width");
        ArgumentGuard.greaterThanOrEqualToZero(height, "height");
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public boolean isEmpty() {
        return this.getLeft() == EMPTY.getLeft() && this.getTop() == EMPTY.getTop() && this.getWidth() == EMPTY.getWidth() && this.getHeight() == EMPTY.getHeight();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region)obj;
        return this.getLeft() == other.getLeft() && this.getTop() == other.getTop() && this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight();
    }

    public int hashCode() {
        return this.left + this.top + this.width + this.height;
    }

    public Region(Location location, RectangleSize size) {
        ArgumentGuard.notNull(location, "location");
        ArgumentGuard.notNull(size, "size");
        this.left = location.getX();
        this.top = location.getY();
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public Region(Region other) {
        ArgumentGuard.notNull(other, "other");
        this.left = other.getLeft();
        this.top = other.getTop();
        this.width = other.getWidth();
        this.height = other.getHeight();
    }

    public Location getLocation() {
        return new Location(this.left, this.top);
    }

    public Region offset(int dx, int dy) {
        return new Region(this.getLocation().offset(dx, dy), this.getSize());
    }

    public Region scale(double scaleRatio) {
        return new Region(this.getLocation().scale(scaleRatio), this.getSize().scale(scaleRatio));
    }

    public RectangleSize getSize() {
        return new RectangleSize(this.width, this.height);
    }

    public void setSize(RectangleSize size) {
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public void setLocation(Location location) {
        ArgumentGuard.notNull(location, "location");
        this.left = location.getX();
        this.top = location.getY();
    }

    private static Iterable<Region> getSubRegionsWithFixedSize(Region containerRegion, RectangleSize subRegionSize) {
        ArgumentGuard.notNull(containerRegion, "containerRegion");
        ArgumentGuard.notNull(subRegionSize, "subRegionSize");
        LinkedList<Region> subRegions = new LinkedList<Region>();
        int subRegionWidth = subRegionSize.getWidth();
        int subRegionHeight = subRegionSize.getHeight();
        ArgumentGuard.greaterThanZero(subRegionWidth, "subRegionSize width");
        ArgumentGuard.greaterThanZero(subRegionHeight, "subRegionSize height");
        if (subRegionWidth > containerRegion.width) {
            subRegionWidth = containerRegion.width;
        }
        if (subRegionHeight > containerRegion.height) {
            subRegionHeight = containerRegion.height;
        }
        if (subRegionWidth == containerRegion.width && subRegionHeight == containerRegion.height) {
            subRegions.add(new Region(containerRegion));
            return subRegions;
        }
        int bottom = containerRegion.top + containerRegion.height - 1;
        int right = containerRegion.left + containerRegion.width - 1;
        for (int currentTop = containerRegion.top; currentTop <= bottom; currentTop += subRegionHeight) {
            if (currentTop + subRegionHeight > bottom) {
                currentTop = bottom - subRegionHeight + 1;
            }
            for (int currentLeft = containerRegion.left; currentLeft <= right; currentLeft += subRegionWidth) {
                if (currentLeft + subRegionWidth > right) {
                    currentLeft = right - subRegionWidth + 1;
                }
                subRegions.add(new Region(currentLeft, currentTop, subRegionWidth, subRegionHeight));
            }
        }
        return subRegions;
    }

    private static Iterable<Region> getSubRegionsWithVaryingSize(Region containerRegion, RectangleSize maxSubRegionSize) {
        ArgumentGuard.notNull(containerRegion, "containerRegion");
        ArgumentGuard.notNull(maxSubRegionSize, "maxSubRegionSize");
        ArgumentGuard.greaterThanZero(maxSubRegionSize.getWidth(), "maxSubRegionSize.getWidth()");
        ArgumentGuard.greaterThanZero(maxSubRegionSize.getHeight(), "maxSubRegionSize.getHeight()");
        LinkedList<Region> subRegions = new LinkedList<Region>();
        int bottom = containerRegion.top + containerRegion.height;
        int right = containerRegion.left + containerRegion.width;
        for (int currentTop = containerRegion.top; currentTop < bottom; currentTop += maxSubRegionSize.getHeight()) {
            int currentBottom = currentTop + maxSubRegionSize.getHeight();
            if (currentBottom > bottom) {
                currentBottom = bottom;
            }
            for (int currentLeft = containerRegion.left; currentLeft < right; currentLeft += maxSubRegionSize.getWidth()) {
                int currentRight = currentLeft + maxSubRegionSize.getWidth();
                if (currentRight > right) {
                    currentRight = right;
                }
                int currentHeight = currentBottom - currentTop;
                int currentWidth = currentRight - currentLeft;
                subRegions.add(new Region(currentLeft, currentTop, currentWidth, currentHeight));
            }
        }
        return subRegions;
    }

    public Iterable<Region> getSubRegions(RectangleSize subRegionSize, boolean isFixedSize) {
        if (isFixedSize) {
            return Region.getSubRegionsWithFixedSize(this, subRegionSize);
        }
        return Region.getSubRegionsWithVaryingSize(this, subRegionSize);
    }

    public Iterable<Region> getSubRegions(RectangleSize subRegionSize) {
        return this.getSubRegions(subRegionSize, false);
    }

    public boolean contains(Region other) {
        int right = this.left + this.width;
        int otherRight = other.getLeft() + other.getWidth();
        int bottom = this.top + this.height;
        int otherBottom = other.getTop() + other.getHeight();
        return this.top <= other.getTop() && this.left <= other.getLeft() && bottom >= otherBottom && right >= otherRight;
    }

    public boolean contains(Location location) {
        return location.getX() >= this.left && location.getX() <= this.left + this.width && location.getY() >= this.top && location.getY() <= this.top + this.height;
    }

    public boolean isIntersected(Region other) {
        int right = this.left + this.width;
        int bottom = this.top + this.height;
        int otherLeft = other.getLeft();
        int otherTop = other.getTop();
        int otherRight = otherLeft + other.getWidth();
        int otherBottom = otherTop + other.getHeight();
        return (this.left <= otherLeft && otherLeft <= right || otherLeft <= this.left && this.left <= otherRight) && (this.top <= otherTop && otherTop <= bottom || otherTop <= this.top && this.top <= otherBottom);
    }

    public void intersect(Region other) {
        if (!this.isIntersected(other)) {
            this.makeEmpty();
            return;
        }
        int otherLeft = other.getLeft();
        int otherTop = other.getTop();
        int intersectionLeft = this.left >= otherLeft ? this.left : otherLeft;
        int intersectionTop = this.top >= otherTop ? this.top : otherTop;
        int right = this.left + this.width;
        int otherRight = otherLeft + other.getWidth();
        int intersectionRight = right <= otherRight ? right : otherRight;
        int intersectionWidth = intersectionRight - intersectionLeft;
        int bottom = this.top + this.height;
        int otherBottom = otherTop + other.getHeight();
        int intersectionBottom = bottom <= otherBottom ? bottom : otherBottom;
        int intersectionHeight = intersectionBottom - intersectionTop;
        this.left = intersectionLeft;
        this.top = intersectionTop;
        this.width = intersectionWidth;
        this.height = intersectionHeight;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Location getMiddleOffset() {
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        return new Location(middleX, middleY);
    }

    public String toString() {
        return "(" + this.left + ", " + this.top + ") " + this.width + "x" + this.height;
    }
}

