/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.ServerConnector;
import com.applitools.eyes.SessionUrls;
import com.applitools.eyes.StepInfo;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.Iso8610CalendarDeserializer;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Calendar;

@JsonIgnoreProperties(value={"$id", "isPassed"})
public class TestResults {
    private int steps;
    private int matches;
    private int mismatches;
    private int missing;
    private int exactMatches;
    private int strictMatches;
    private int contentMatches;
    private int layoutMatches;
    private int noneMatches;
    private String url;
    private boolean isNew;
    private TestResultsStatus status;
    private String name;
    private String secretToken;
    private String id;
    private String appName;
    private String batchName;
    private String batchId;
    private String branchName;
    private String hostOS;
    private String hostApp;
    private RectangleSize hostDisplaySize;
    @JsonDeserialize(using=Iso8610CalendarDeserializer.class)
    private Calendar startedAt;
    private int duration;
    private boolean isDifferent;
    private boolean isAborted;
    private SessionUrls appUrls;
    private SessionUrls apiUrls;
    private StepInfo[] stepsInfo;
    private ServerConnector serverConnector;

    public StepInfo[] getStepsInfo() {
        return this.stepsInfo;
    }

    public void setStepsInfo(StepInfo[] stepsInfo) {
        this.stepsInfo = stepsInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getBatchName() {
        return this.batchName;
    }

    public void setBatchName(String batchName) {
        this.batchName = batchName;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getHostOS() {
        return this.hostOS;
    }

    public void setHostOS(String hostOS) {
        this.hostOS = hostOS;
    }

    public String getHostApp() {
        return this.hostApp;
    }

    public void setHostApp(String hostApp) {
        this.hostApp = hostApp;
    }

    public RectangleSize getHostDisplaySize() {
        return this.hostDisplaySize;
    }

    public void setHostDisplaySize(RectangleSize hostDisplaySize) {
        this.hostDisplaySize = hostDisplaySize;
    }

    public Calendar getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Calendar startedAt) {
        this.startedAt = startedAt;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @JsonGetter(value="isDifferent")
    public boolean isDifferent() {
        return this.isDifferent;
    }

    @JsonSetter(value="isDifferent")
    public void setDifferent(boolean different) {
        this.isDifferent = different;
    }

    @JsonGetter(value="isAborted")
    public boolean isAborted() {
        return this.isAborted;
    }

    @JsonSetter(value="isAborted")
    public void setAborted(boolean aborted) {
        this.isAborted = aborted;
    }

    public SessionUrls getAppUrls() {
        return this.appUrls;
    }

    public void setAppUrls(SessionUrls appUrls) {
        this.appUrls = appUrls;
    }

    public SessionUrls getApiUrls() {
        return this.apiUrls;
    }

    public void setApiUrls(SessionUrls apiUrls) {
        this.apiUrls = apiUrls;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getMatches() {
        return this.matches;
    }

    public int getMismatches() {
        return this.mismatches;
    }

    public int getMissing() {
        return this.missing;
    }

    public int getExactMatches() {
        return this.exactMatches;
    }

    public int getStrictMatches() {
        return this.strictMatches;
    }

    public int getContentMatches() {
        return this.contentMatches;
    }

    public int getLayoutMatches() {
        return this.layoutMatches;
    }

    public int getNoneMatches() {
        return this.noneMatches;
    }

    public String getUrl() {
        return this.url;
    }

    @JsonGetter(value="isNew")
    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPassed() {
        return this.status == TestResultsStatus.Passed;
    }

    public TestResultsStatus getStatus() {
        return this.status;
    }

    void setSteps(int steps) {
        ArgumentGuard.greaterThanOrEqualToZero(steps, "steps");
        this.steps = steps;
    }

    void setMatches(int matches) {
        ArgumentGuard.greaterThanOrEqualToZero(matches, "matches");
        this.matches = matches;
    }

    void setMismatches(int mismatches) {
        ArgumentGuard.greaterThanOrEqualToZero(mismatches, "mismatches");
        this.mismatches = mismatches;
    }

    void setMissing(int missing) {
        ArgumentGuard.greaterThanOrEqualToZero(missing, "missing");
        this.missing = missing;
    }

    void setExactMatches(int exactMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(exactMatches, "exactMatches");
        this.exactMatches = exactMatches;
    }

    void setStrictMatches(int strictMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(strictMatches, "strictMatches");
        this.strictMatches = strictMatches;
    }

    void setContentMatches(int contentMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(contentMatches, "contentMatches");
        this.contentMatches = contentMatches;
    }

    void setLayoutMatches(int layoutMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(layoutMatches, "layoutMatches");
        this.layoutMatches = layoutMatches;
    }

    void setNoneMatches(int noneMatches) {
        ArgumentGuard.greaterThanOrEqualToZero(noneMatches, "noneMatches");
        this.noneMatches = noneMatches;
    }

    void setUrl(String url) {
        this.url = url;
    }

    @JsonSetter(value="isNew")
    void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    void setStatus(TestResultsStatus status) {
        this.status = status;
    }

    void setServerConnector(ServerConnector serverConnector) {
        this.serverConnector = serverConnector;
    }

    public void delete() {
        this.serverConnector.deleteSession(this);
    }

    public String toString() {
        String isNewTestStr = this.isNew ? "New test" : "Existing test";
        return isNewTestStr + " [ steps: " + this.getSteps() + ", matches: " + this.getMatches() + ", mismatches:" + this.getMismatches() + ", missing: " + this.getMissing() + "] , URL: " + this.getUrl();
    }
}

