/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.utils.EyesSyncObject;
import java.util.HashSet;
import org.apache.commons.lang3.tuple.Pair;

public class SyncTaskListener<T>
implements TaskListener<T> {
    private final Logger logger;
    private String id;
    private final EyesSyncObject syncObject;
    private T reference = null;

    public SyncTaskListener(Logger logger) {
        this(logger, "");
    }

    public SyncTaskListener(Logger logger, String id) {
        this.logger = logger;
        this.id = id;
        this.syncObject = new EyesSyncObject(logger, id);
    }

    public void setId(String id) {
        this.id = id;
        this.syncObject.setId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete(T taskResponse) {
        EyesSyncObject eyesSyncObject = this.syncObject;
        synchronized (eyesSyncObject) {
            this.reference = taskResponse;
            this.syncObject.notifyObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFail() {
        EyesSyncObject eyesSyncObject = this.syncObject;
        synchronized (eyesSyncObject) {
            this.syncObject.notifyObject();
        }
        if (this.logger != null) {
            this.logger.log(new HashSet<String>(), Stage.GENERAL, Pair.of((Object)"message", (Object)String.format("Task %s has failed", this.id)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        EyesSyncObject eyesSyncObject = this.syncObject;
        synchronized (eyesSyncObject) {
            if (this.syncObject.isNotified()) {
                return this.reference;
            }
            try {
                this.syncObject.waitForNotify();
            }
            catch (InterruptedException e) {
                throw new EyesException("Failed waiting for task", e);
            }
            return this.reference;
        }
    }
}

