/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.LogHandler;
import com.applitools.eyes.MultiLogHandler;
import com.applitools.eyes.logging.ClientEvent;
import com.applitools.eyes.logging.Message;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.utils.GeneralUtils;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.tuple.Pair;

public class Logger {
    private final MultiLogHandler logHandler = new MultiLogHandler(new LogHandler[0]);
    private String agentId;

    public Logger() {
    }

    public Logger(LogHandler handler) {
        this();
        this.logHandler.addLogHandler(handler);
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    public void setLogHandler(LogHandler handler) {
        if (handler == null) {
            this.logHandler.clear();
        } else {
            this.logHandler.addLogHandler(handler);
        }
    }

    @SafeVarargs
    public final void log(String testId, Stage stage, Pair<String, ?> ... data) {
        this.logInner(TraceLevel.Notice, testId == null ? null : Collections.singleton(testId), stage, null, data);
    }

    @SafeVarargs
    public final void log(Set<String> testIds, Stage stage, Pair<String, ?> ... data) {
        this.logInner(TraceLevel.Notice, testIds, stage, null, data);
    }

    @SafeVarargs
    public final void log(String testId, Stage stage, Type type, Pair<String, ?> ... data) {
        this.logInner(TraceLevel.Notice, testId == null ? null : Collections.singleton(testId), stage, type, data);
    }

    @SafeVarargs
    public final void log(Set<String> testIds, Stage stage, Type type, Pair<String, ?> ... data) {
        this.logInner(TraceLevel.Notice, testIds, stage, type, data);
    }

    @SafeVarargs
    public final void log(TraceLevel level, String testId, Stage stage, Pair<String, ?> ... data) {
        this.logInner(level, testId == null ? null : Collections.singleton(testId), stage, null, data);
    }

    @SafeVarargs
    public final void log(TraceLevel level, Set<String> testIds, Stage stage, Type type, Pair<String, ?> ... data) {
        this.logInner(level, testIds, stage, type, data);
    }

    @SafeVarargs
    private final void logInner(TraceLevel level, Set<String> testIds, Stage stage, Type type, Pair<String, ?> ... data) {
        String currentTime = GeneralUtils.toISO8601DateTime(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        ClientEvent event = new ClientEvent(currentTime, this.createMessageFromLog(testIds, stage, type, 4, data), level);
        this.logHandler.onMessage(event);
    }

    @SafeVarargs
    private final Message createMessageFromLog(Set<String> testIds, Stage stage, Type type, int methodsBack, Pair<String, ?> ... data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (data != null && data.length > 0) {
            for (Pair<String, ?> pair : data) {
                map.put((String)pair.getLeft(), pair.getRight());
            }
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String stackTrace = "";
        if (stackTraceElements.length > methodsBack) {
            stackTrace = stackTrace + stackTraceElements[methodsBack].getClassName() + "." + stackTraceElements[methodsBack].getMethodName() + "()";
        }
        return new Message(this.agentId, stage, type, testIds, Thread.currentThread().getId(), stackTrace, map);
    }

    @SafeVarargs
    public final Message createMessageFromLog(Set<String> testIds, Stage stage, Type type, Pair<String, ?> ... data) {
        return this.createMessageFromLog(testIds, stage, type, 3, data);
    }
}

