/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.ArrayUtils;

public class GeneralUtils {
    private static final String DATE_FORMAT_ISO8601_FOR_OUTPUT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DATE_FORMAT_ISO8601_FOR_INPUT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final String DATE_FORMAT_RFC1123 = "E, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String QUESTION_MARK = "?";

    private GeneralUtils() {
    }

    public static String readToEnd(InputStream inputStream) throws IOException {
        int length;
        ArgumentGuard.notNull(inputStream, "inputStream");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return new String(baos.toByteArray());
    }

    public static String toISO8601DateTime(Calendar calendar) {
        ArgumentGuard.notNull(calendar, "calendar");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_ISO8601_FOR_INPUT, Locale.ENGLISH);
        formatter.setTimeZone(calendar.getTimeZone());
        return formatter.format(calendar.getTime());
    }

    public static String toRfc1123(Calendar calendar) {
        ArgumentGuard.notNull(calendar, "calendar");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_RFC1123, Locale.ENGLISH);
        formatter.setTimeZone(calendar.getTimeZone());
        return formatter.format(calendar.getTime());
    }

    public static Calendar fromISO8601DateTime(String dateTime) throws ParseException {
        ArgumentGuard.notNull(dateTime, "dateTime");
        String timezoneId = "UTC";
        if (dateTime.contains("T")) {
            if (dateTime.endsWith("Z")) {
                dateTime = dateTime.replaceAll("\\.(\\d+)Z", "Z");
            } else if (dateTime.contains("+")) {
                dateTime = dateTime.replaceAll("\\.(\\d+)\\+", "+");
                timezoneId = timezoneId + "+" + dateTime.split("\\+")[1];
            } else if (dateTime.contains("-")) {
                dateTime = dateTime.replaceAll("\\.(\\d+)\\+", "+");
                timezoneId = timezoneId + "-" + dateTime.split("-")[1];
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_ISO8601_FOR_INPUT);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezoneId));
        cal.setTime(formatter.parse(dateTime));
        return cal;
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("sleep interrupted", ex);
        }
    }

    public static Date getDate(DateFormat format, String date) {
        try {
            return format.parse(date);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long getFullSecondsElapsedTimeMillis(long start, long end) {
        return (long)Math.ceil((double)(end - start) / 1000.0) * 1000L;
    }

    public static String readTextFromResource(String resource) {
        InputStream is = GeneralUtils.class.getClassLoader().getResourceAsStream(resource);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EyesException("Failed to read text from resource: ", e);
        }
        return sb.toString();
    }

    public static void logExceptionStackTrace(Logger logger, Throwable ex) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
        PrintWriter writer = new PrintWriter(stream, true);
        ex.printStackTrace(writer);
        logger.log(ex.toString());
        try {
            logger.log(stream.toString("UTF-8"));
            writer.close();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static URI getServerUrl() {
        try {
            String serverURL = GeneralUtils.getEnvString("APPLITOOLS_SERVER_URL");
            if (serverURL == null) {
                serverURL = "https://eyesapi.applitools.com";
            }
            URI uri = new URI(serverURL);
            return uri;
        }
        catch (URISyntaxException ex) {
            throw new EyesException(ex.getMessage(), ex);
        }
    }

    public static byte[] getGzipByteArrayOutputStream(String domJson) {
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(resultStream);
            gzip.write(domJson.getBytes(StandardCharsets.UTF_8));
            gzip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultStream.toByteArray();
    }

    public static byte[] getUnGzipByteArrayOutputStream(byte[] gZippedString) throws IOException {
        ByteArrayInputStream bytein = new ByteArrayInputStream(gZippedString);
        GZIPInputStream gzin = new GZIPInputStream(bytein);
        ByteArrayOutputStream byteout = new ByteArrayOutputStream();
        int res = 0;
        byte[] buf = new byte[1024];
        while (res >= 0) {
            res = gzin.read(buf, 0, buf.length);
            if (res <= 0) continue;
            byteout.write(buf, 0, res);
        }
        return byteout.toByteArray();
    }

    public static <T> T parseJsonToObject(String jsonStr, Class<T> tClass) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object executeScriptMap = tClass != null ? mapper.readValue(jsonStr, tClass) : mapper.readValue(jsonStr, new TypeReference<T>(){});
        return (T)executeScriptMap;
    }

    public static String getSha256hash(Byte[] content) {
        byte[] bytes = ArrayUtils.toPrimitive((Byte[])content);
        return GeneralUtils.getSha256hash(bytes);
    }

    public static String getSha256hash(byte[] content) {
        if (content == null) {
            return null;
        }
        byte[] buffer = new byte[8192];
        try {
            int count;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(content));
            while ((count = bis.read(buffer)) > 0) {
                digest.update(buffer, 0, count);
            }
            bis.close();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest.digest()) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sanitizeURL(String urlToSanitize) {
        String encoded = urlToSanitize.replace(" ", "%20");
        if (encoded.contains("#")) {
            encoded = encoded.substring(0, encoded.indexOf("#"));
        }
        if (encoded.endsWith(QUESTION_MARK)) {
            encoded = encoded.substring(0, encoded.indexOf(QUESTION_MARK));
        }
        return encoded;
    }

    public static String getEnvString(String applitools_env) {
        return System.getenv(applitools_env) == null ? System.getenv("bamboo_" + applitools_env) : System.getenv(applitools_env);
    }

    public static boolean getDontCloseBatches() {
        return "true".equalsIgnoreCase(GeneralUtils.getEnvString("APPLITOOLS_DONT_CLOSE_BATCHES"));
    }
}

