/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.Logger;
import com.applitools.utils.GeneralUtils;
import java.util.UUID;
import java.util.concurrent.Future;

public abstract class AsyncRequest {
    private static final int REQUEST_TIMEOUT = 60000;
    private static final int SLEEP_DURATION = 5000;
    private int timePassed = 0;
    protected Logger logger;
    protected final String requestId;

    public AsyncRequest(Logger logger) {
        this.logger = logger;
        this.requestId = UUID.randomUUID().toString();
    }

    public abstract AsyncRequest header(String var1, String var2);

    public abstract Future<?> method(String var1, AsyncRequestCallback var2, Object var3, String var4, boolean var5);

    public Future<?> method(final String method, final AsyncRequestCallback callback, final Object data, final String contentType) {
        this.header("x-applitools-eyes-client-request-id", this.requestId);
        this.logger.verbose(String.format("Sending async request to the server. ID: %s, Type: %s", this.requestId, method));
        return this.method(method, new AsyncRequestCallback(){

            @Override
            public void onComplete(Response response) {
                AsyncRequest.this.logger.verbose(String.format("Async request onComplete. ID: %s, Type: %s", AsyncRequest.this.requestId, method));
                try {
                    callback.onComplete(response);
                }
                catch (Throwable t) {
                    callback.onFail(t);
                }
            }

            @Override
            public void onFail(Throwable throwable) {
                if (AsyncRequest.this.timePassed >= 60000) {
                    AsyncRequest.this.logger.log(String.format("Async request onFail. ID: %s, Type: %s", AsyncRequest.this.requestId, method));
                    callback.onFail(throwable);
                    return;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AsyncRequest.this.timePassed = AsyncRequest.this.timePassed + 5000;
                GeneralUtils.logExceptionStackTrace(AsyncRequest.this.logger, throwable);
                AsyncRequest.this.logger.log(String.format("Failed sending request. Trying again. ID: %s, Type: %s", AsyncRequest.this.requestId, method));
                AsyncRequest.this.method(method, callback, data, contentType);
            }
        }, data, contentType, true);
    }
}

