/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.utils.GeneralUtils;

public abstract class AbstractAsyncCallback<T>
implements AsyncRequestCallback {
    private final Logger logger;
    private final TaskListener<T> listener;

    public AbstractAsyncCallback(Logger logger, TaskListener<T> listener) {
        this.logger = logger;
        this.listener = listener;
    }

    protected abstract T onCompleteInner(Response var1);

    @Override
    public void onComplete(Response response) {
        try {
            this.listener.onComplete(this.onCompleteInner(response));
        }
        catch (Throwable t) {
            this.onFail(t);
        }
        finally {
            response.close();
        }
    }

    @Override
    public void onFail(Throwable throwable) {
        GeneralUtils.logExceptionStackTrace(this.logger, throwable);
        this.listener.onFail();
    }
}

