/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.IPutFuture;
import com.applitools.eyes.Logger;
import com.applitools.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class RateLimiter {
    private final Logger logger;
    private List<IPutFuture> awaitingTasks = Collections.synchronizedList(new ArrayList());
    private List<IPutFuture> runningTasks = Collections.synchronizedList(new ArrayList());
    private int maxConcurrentTasks;
    private final Object lock = new Object();
    private Thread pollingThread = new Thread((Runnable)new RateLimiterRunnable(), "PutThrottler");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(IPutFuture putFuture) {
        Object object = this.lock;
        synchronized (object) {
            this.awaitingTasks.add(putFuture);
            if (!this.pollingThread.isAlive()) {
                this.pollingThread.start();
            }
        }
    }

    public boolean isSlotAvailable() {
        return this.runningTasks.size() < this.maxConcurrentTasks;
    }

    public RateLimiter(Logger logger, int maxConcurrentTasks) {
        this.logger = logger;
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    public void run() {
        this.logger.verbose("enter");
        this.pollingThread.run();
        this.logger.verbose("exit");
    }

    class RateLimiterRunnable
    implements Runnable {
        RateLimiterRunnable() {
        }

        @Override
        public void run() {
            RateLimiter.this.logger.verbose("enter");
            while (true) {
                if (!RateLimiter.this.isSlotAvailable()) {
                    GeneralUtils.sleep(250L);
                    continue;
                }
                this.executeTask();
                this.removeCompletedTasks();
                if (RateLimiter.this.awaitingTasks.isEmpty() && RateLimiter.this.runningTasks.isEmpty()) break;
            }
            RateLimiter.this.logger.verbose("exit");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeTask() {
            IPutFuture putFuture;
            RateLimiter.this.logger.verbose("enter");
            if (RateLimiter.this.awaitingTasks.isEmpty()) {
                return;
            }
            Object object = RateLimiter.this.lock;
            synchronized (object) {
                putFuture = (IPutFuture)RateLimiter.this.awaitingTasks.get(0);
                RateLimiter.this.logger.verbose("executing task " + putFuture);
                RateLimiter.this.runningTasks.add(putFuture);
                RateLimiter.this.awaitingTasks.remove(putFuture);
            }
            try {
                putFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            RateLimiter.this.logger.verbose("exit");
        }

        private void removeCompletedTasks() {
            RateLimiter.this.logger.verbose("enter");
            Iterator iterator = RateLimiter.this.runningTasks.iterator();
            while (iterator.hasNext()) {
                IPutFuture future = (IPutFuture)iterator.next();
                if (!future.isDone()) continue;
                RateLimiter.this.logger.verbose("removing done task " + future);
                iterator.remove();
            }
            RateLimiter.this.logger.verbose("exit");
        }
    }
}

