/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.LogHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiLogHandler
implements LogHandler {
    private List<LogHandler> logHandlers = new ArrayList<LogHandler>();

    public MultiLogHandler(LogHandler ... logHandlers) {
        this.logHandlers.addAll(Arrays.asList(logHandlers));
    }

    @Override
    public void open() {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.open();
        }
    }

    @Override
    public void onMessage(boolean verbose, String logString) {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.onMessage(verbose, logString);
        }
    }

    @Override
    public void close() {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.close();
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    public void addLogHandler(LogHandler logHandler) {
        this.logHandlers.add(logHandler);
    }
}

