/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.LogHandler;
import com.applitools.utils.ArgumentGuard;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class FileLogger
implements LogHandler {
    private final boolean isVerbose;
    private final String filename;
    private final boolean append;
    private BufferedWriter fileWriter;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public FileLogger(String filename, boolean append, boolean isVerbose) {
        ArgumentGuard.notNullOrEmpty(filename, "filename");
        this.filename = filename;
        this.append = append;
        this.isVerbose = isVerbose;
        this.fileWriter = null;
    }

    public FileLogger(boolean isVerbose) {
        this("eyes.log", true, isVerbose);
    }

    @Override
    public void open() {
        if (this.fileWriter != null) {
            return;
        }
        try {
            File file = new File(this.filename);
            File path = file.getParentFile();
            if (path != null && !path.exists()) {
                System.out.println("No Folder");
                boolean success = path.mkdirs();
                System.out.println("Folder created");
            }
            this.fileWriter = new BufferedWriter(new FileWriter(file, this.append));
        }
        catch (IOException e) {
            throw new EyesException("Failed to create log file!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onMessage(boolean verbose, String logString) {
        if (this.fileWriter != null && (!verbose || this.isVerbose)) {
            BufferedWriter bufferedWriter = this.fileWriter;
            synchronized (bufferedWriter) {
                try {
                    this.fileWriter.write(this.getFormattedTimeStamp() + " Eyes: " + logString);
                    this.fileWriter.newLine();
                    this.fileWriter.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileWriter = null;
    }

    @Override
    public boolean isOpen() {
        return this.fileWriter != null;
    }

    private String getFormattedTimeStamp() {
        return this.dateFormat.format(Calendar.getInstance().getTime());
    }
}

